/*
 * Decompiled with CFR 0.152.
 */
package li.naska.spring.ejb;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PreDestroy;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractSpringSingletonBean {
    private final Map<String, ConfigurableApplicationContext> applicationContextReferences = new WeakHashMap<String, ConfigurableApplicationContext>();

    public ConfigurableApplicationContext getApplicationContext(String key) {
        return this.applicationContextReferences.get(key);
    }

    public void setApplicationContext(String key, ConfigurableApplicationContext applicationContext) {
        this.applicationContextReferences.put(key, applicationContext);
    }

    @PreDestroy
    void doReleaseBean() {
        Iterator<Map.Entry<String, ConfigurableApplicationContext>> iterator = this.applicationContextReferences.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().close();
            iterator.remove();
        }
    }
}

