/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.function.Function;
import li.pitschmann.knx.core.annotations.Nullable;
import li.pitschmann.knx.core.body.Body;
import li.pitschmann.knx.core.body.ConnectRequestBody;
import li.pitschmann.knx.core.body.ConnectResponseBody;
import li.pitschmann.knx.core.body.ConnectionStateRequestBody;
import li.pitschmann.knx.core.body.ConnectionStateResponseBody;
import li.pitschmann.knx.core.body.DescriptionRequestBody;
import li.pitschmann.knx.core.body.DescriptionResponseBody;
import li.pitschmann.knx.core.body.DisconnectRequestBody;
import li.pitschmann.knx.core.body.DisconnectResponseBody;
import li.pitschmann.knx.core.body.RequestBody;
import li.pitschmann.knx.core.body.ResponseBody;
import li.pitschmann.knx.core.body.RoutingIndicationBody;
import li.pitschmann.knx.core.body.SearchRequestBody;
import li.pitschmann.knx.core.body.SearchResponseBody;
import li.pitschmann.knx.core.body.TunnelingAckBody;
import li.pitschmann.knx.core.body.TunnelingRequestBody;
import li.pitschmann.knx.core.communication.KnxStatistic;

public final class KnxStatisticJsonSerializer
implements JsonSerializer<KnxStatistic> {
    public static final KnxStatisticJsonSerializer INSTANCE = new KnxStatisticJsonSerializer();

    private KnxStatisticJsonSerializer() {
    }

    public JsonElement serialize(KnxStatistic src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonStatistic = new JsonObject();
        JsonObject inboundTotal = new JsonObject();
        inboundTotal.addProperty("packets", (Number)src.getNumberOfBodyReceived());
        inboundTotal.addProperty("bytes", (Number)src.getNumberOfBytesReceived());
        JsonObject inbound = new JsonObject();
        inbound.add("total", (JsonElement)inboundTotal);
        Function<Class<? extends Body>, Long> receivedFunction = arg_0 -> ((KnxStatistic)src).getNumberOfBodyReceived(arg_0);
        inbound.add("search", (JsonElement)this.getRequestResponsePair(receivedFunction, SearchRequestBody.class, SearchResponseBody.class));
        inbound.add("description", (JsonElement)this.getRequestResponsePair(receivedFunction, DescriptionRequestBody.class, DescriptionResponseBody.class));
        inbound.add("connect", (JsonElement)this.getRequestResponsePair(receivedFunction, ConnectRequestBody.class, ConnectResponseBody.class));
        inbound.add("connection_state", (JsonElement)this.getRequestResponsePair(receivedFunction, ConnectionStateRequestBody.class, ConnectionStateResponseBody.class));
        inbound.add("tunneling", (JsonElement)this.getRequestResponsePair(receivedFunction, TunnelingRequestBody.class, TunnelingAckBody.class));
        inbound.add("indication", (JsonElement)this.getRequestResponsePair(receivedFunction, null, RoutingIndicationBody.class));
        inbound.add("disconnect", (JsonElement)this.getRequestResponsePair(receivedFunction, DisconnectRequestBody.class, DisconnectResponseBody.class));
        JsonObject outboundTotal = new JsonObject();
        outboundTotal.addProperty("packets", (Number)src.getNumberOfBodySent());
        outboundTotal.addProperty("bytes", (Number)src.getNumberOfBytesSent());
        JsonObject outbound = new JsonObject();
        outbound.add("total", (JsonElement)outboundTotal);
        Function<Class<? extends Body>, Long> sentFunction = arg_0 -> ((KnxStatistic)src).getNumberOfBodySent(arg_0);
        outbound.add("search", (JsonElement)this.getRequestResponsePair(sentFunction, SearchRequestBody.class, SearchResponseBody.class));
        outbound.add("description", (JsonElement)this.getRequestResponsePair(sentFunction, DescriptionRequestBody.class, DescriptionResponseBody.class));
        outbound.add("connect", (JsonElement)this.getRequestResponsePair(sentFunction, ConnectRequestBody.class, ConnectResponseBody.class));
        outbound.add("connection_state", (JsonElement)this.getRequestResponsePair(sentFunction, ConnectionStateRequestBody.class, ConnectionStateResponseBody.class));
        outbound.add("tunneling", (JsonElement)this.getRequestResponsePair(sentFunction, TunnelingRequestBody.class, TunnelingAckBody.class));
        outbound.add("indication", (JsonElement)this.getRequestResponsePair(sentFunction, RoutingIndicationBody.class, null));
        outbound.add("disconnect", (JsonElement)this.getRequestResponsePair(sentFunction, DisconnectRequestBody.class, DisconnectResponseBody.class));
        JsonObject errorTotal = new JsonObject();
        errorTotal.addProperty("packets", (Number)src.getNumberOfErrors());
        errorTotal.addProperty("rate", (Number)src.getErrorRate());
        JsonObject error = new JsonObject();
        error.add("total", (JsonElement)errorTotal);
        jsonStatistic.add("inbound", (JsonElement)inbound);
        jsonStatistic.add("outbound", (JsonElement)outbound);
        jsonStatistic.add("error", (JsonElement)error);
        return jsonStatistic;
    }

    private JsonObject getRequestResponsePair(Function<Class<? extends Body>, Long> function, @Nullable Class<? extends RequestBody> requestBodyClass, @Nullable Class<? extends ResponseBody> responseBodyClass) {
        JsonObject pair = new JsonObject();
        pair.addProperty("request", (Number)(requestBodyClass == null ? 0L : function.apply(requestBodyClass)));
        pair.addProperty("response", (Number)(responseBodyClass == null ? 0L : function.apply(responseBodyClass)));
        return pair;
    }
}

