/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import li.pitschmann.knx.core.address.GroupAddress;
import li.pitschmann.knx.core.datapoint.DataPointType;
import li.pitschmann.knx.core.plugin.api.v1.controllers.AbstractController;
import li.pitschmann.knx.core.plugin.api.v1.json.WriteRequest;
import li.pitschmann.knx.core.plugin.api.v1.json.WriteResponse;
import li.pitschmann.knx.core.utils.ByteFormatter;
import ro.pippo.controller.Consumes;
import ro.pippo.controller.POST;
import ro.pippo.controller.Produces;
import ro.pippo.controller.extractor.Body;

public final class WriteRequestController
extends AbstractController {
    private static final WriteResponse EMPTY_RESPONSE = new WriteResponse();

    @POST(value={"/write"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public WriteResponse writeRequest(@Body WriteRequest writeRequest) {
        this.log.trace("Http Write Request received: {}", (Object)writeRequest);
        GroupAddress groupAddress = writeRequest.getGroupAddress();
        if (groupAddress == null) {
            this.log.warn("Could not find group address in request.");
            this.getResponse().badRequest();
            return EMPTY_RESPONSE;
        }
        byte[] rawToWrite = writeRequest.getRaw();
        if (rawToWrite == null || rawToWrite.length == 0) {
            DataPointType<?> dpt = writeRequest.getDataPointType();
            String[] dptValues = writeRequest.getValues();
            if (dpt == null || dptValues == null || dptValues.length == 0) {
                this.log.error("No DPT or/and DPT values defined for write request: {}", (Object)writeRequest);
                WriteResponse response = new WriteResponse();
                this.getResponse().badRequest();
                return response;
            }
            this.log.debug("DPT and DPT values received for write request: {}", (Object)writeRequest);
            rawToWrite = dpt.of(dptValues).toByteArray();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Write request to group address '{}' with bytes: {}", (Object)groupAddress, (Object)ByteFormatter.formatHexAsString((byte[])rawToWrite));
        }
        if (this.getKnxClient().writeRequest(groupAddress, rawToWrite)) {
            this.log.debug("Acknowledge received for write request: {}", (Object)writeRequest);
            this.getResponse().accepted();
        } else {
            this.log.warn("No or unexpected acknowledge received for write request: {}", (Object)writeRequest);
            this.getResponse().internalError();
        }
        return EMPTY_RESPONSE;
    }
}

