/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.knxproj.XmlProject;
import li.pitschmann.knx.core.plugin.api.gson.ApiGsonEngine;
import li.pitschmann.knx.core.plugin.api.v1.controllers.ProjectController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.ReadRequestController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.StatisticController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.StatusController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.WriteRequestController;
import ro.pippo.controller.Controller;
import ro.pippo.controller.ControllerApplication;
import ro.pippo.controller.ControllerFactory;
import ro.pippo.controller.GET;
import ro.pippo.controller.Produces;
import ro.pippo.core.ContentTypeEngine;
import ro.pippo.guice.GuiceControllerFactory;

public class ApiApplication
extends ControllerApplication {
    private KnxClient knxClient;
    private XmlProject xmlProject;

    public void setKnxClient(KnxClient knxClient) {
        this.knxClient = knxClient;
    }

    public void setXmlProject(XmlProject xmlProject) {
        this.xmlProject = xmlProject;
    }

    protected void onInit() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            @Provides
            private final KnxClient providesKnxClient() {
                return ApiApplication.this.knxClient;
            }

            @Provides
            private final XmlProject providesXmlProject() {
                return ApiApplication.this.xmlProject;
            }
        }});
        this.setControllerFactory((ControllerFactory)new GuiceControllerFactory(injector));
        this.getContentTypeEngines().setContentTypeEngine((ContentTypeEngine)ApiGsonEngine.INSTANCE);
        this.addControllers(new Class[]{HeartbeatController.class, ReadRequestController.class, WriteRequestController.class, StatusController.class, StatisticController.class, ProjectController.class});
    }

    public static final class HeartbeatController
    extends Controller {
        @GET(value={"/api/ping"})
        @Produces(value={"text/plain"})
        public String healthCheck() {
            this.getResponse().noCache().text().ok();
            return "OK";
        }
    }
}

