/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.config.ConfigValue;
import li.pitschmann.knx.core.knxproj.XmlProject;
import li.pitschmann.knx.core.plugin.ExtensionPlugin;
import li.pitschmann.knx.core.plugin.IntegerConfigValue;
import li.pitschmann.knx.core.plugin.api.ApiApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.Pippo;

public class ApiPlugin
implements ExtensionPlugin {
    public static final IntegerConfigValue PORT = new IntegerConfigValue("port", () -> 8338, Objects::nonNull);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private AtomicBoolean ready = new AtomicBoolean();
    private KnxClient client;
    private Pippo pippo;
    private int pippoPort = -1;

    public void onInitialization(KnxClient client) {
        this.client = Objects.requireNonNull(client);
        this.pippoPort = (Integer)client.getConfig((ConfigValue)PORT);
        this.log.info("Initialized '{}' with: [port={}]", (Object)this.getClass().getName(), (Object)this.pippoPort);
    }

    public void onStart() {
        XmlProject xmlProject = this.client.getConfig().getProject();
        ApiApplication app = new ApiApplication();
        app.setXmlProject(xmlProject);
        app.setKnxClient(this.client);
        app.getContentTypeEngine("application/json");
        this.pippo = new Pippo((Application)app);
        this.startPippo(this.pippo);
        this.ready.getAndSet(true);
        this.pippoPort = this.pippo.getServer().getPort();
        this.log.debug("API Plugin and Web Server started at port {}: {}", (Object)this.pippoPort, (Object)this.client);
    }

    public void onShutdown() {
        this.ready.getAndSet(false);
        this.pippoPort = -1;
        if (this.pippo != null) {
            this.pippo.stop();
            this.pippo = null;
        }
        this.log.debug("API Plugin and Web Server stopped.");
    }

    protected void startPippo(Pippo pippo) {
        pippo.start(this.pippoPort);
    }

    public final int getPort() {
        return this.pippoPort;
    }

    public final boolean isReady() {
        return this.ready.get();
    }
}

