/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.controller.Controller;
import ro.pippo.controller.Path;

@Path(value={"/api/v1"})
public abstract class AbstractController
extends Controller {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private KnxClient knxClient;

    public AbstractController(KnxClient knxClient) {
        this.knxClient = Objects.requireNonNull(knxClient);
    }

    protected final KnxClient getKnxClient() {
        return this.knxClient;
    }

    protected final <T> List<T> limitAndGetAsList(Collection<T> list) {
        int start = this.getRequest().getParameter("start").toInt(0);
        int limit = this.getRequest().getParameter("limit").toInt(Integer.MAX_VALUE);
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"Start should be 0 or greater: {}", (Object[])new Object[]{start});
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Limit should be 0 or greater: {}", (Object[])new Object[]{limit});
        if (start == 0 && limit == Integer.MAX_VALUE) {
            this.log.trace("No range defined.");
            return new ArrayList<T>(list);
        }
        this.log.trace("Range defined: start={}, limit={}", (Object)start, (Object)limit);
        return list.stream().skip(start).limit(limit).collect(Collectors.toList());
    }
}

