/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import java.util.List;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.knxproj.XmlGroupAddress;
import li.pitschmann.knx.core.knxproj.XmlGroupAddressStyle;
import li.pitschmann.knx.core.knxproj.XmlGroupRange;
import li.pitschmann.knx.core.knxproj.XmlProject;
import li.pitschmann.knx.core.plugin.api.v1.controllers.AbstractController;
import li.pitschmann.knx.core.plugin.api.v1.json.ProjectStructureResponse;
import li.pitschmann.knx.core.utils.Preconditions;
import ro.pippo.controller.GET;
import ro.pippo.controller.Produces;
import ro.pippo.controller.extractor.Param;

public final class ProjectController
extends AbstractController {
    public ProjectController(KnxClient knxClient) {
        super(knxClient);
    }

    @GET(value={"/project"})
    @Produces(value={"application/json"})
    public ProjectStructureResponse projectStructure() {
        this.log.trace("Request for project overview");
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        if (xmlProject == null) {
            this.log.error("No project file found.");
            this.getResponse().notFound();
            return null;
        }
        ProjectStructureResponse response = new ProjectStructureResponse();
        response.setId(xmlProject.getId());
        response.setName(xmlProject.getName());
        response.setGroupAddressStyle(xmlProject.getGroupAddressStyle().getCode());
        response.setVersion(xmlProject.getVersion());
        response.setNumberOfGroupRanges(xmlProject.getGroupRanges().size());
        response.setNumberOfGroupAddresses(xmlProject.getGroupAddresses().size());
        this.getResponse().ok();
        return response;
    }

    @GET(value={"/project/ranges"})
    @Produces(value={"application/json"})
    public List<XmlGroupRange> getGroupRanges() {
        this.log.trace("Request for all main group ranges in project");
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        XmlGroupAddressStyle groupAddressStyle = xmlProject.getGroupAddressStyle();
        if (groupAddressStyle == XmlGroupAddressStyle.THREE_LEVEL || groupAddressStyle == XmlGroupAddressStyle.TWO_LEVEL) {
            List mainRanges = xmlProject.getMainGroupRanges();
            this.log.debug("All main group ranges found: {}", (Object)mainRanges);
            this.getResponse().ok();
            return this.limitAndGetAsList(mainRanges);
        }
        this.getResponse().forbidden();
        return List.of();
    }

    @GET(value={"/project/ranges/{main: \\d+}"})
    @Produces(value={"application/json"})
    public List<XmlGroupRange> getGroupRanges(@Param int main) {
        this.log.trace("Request for middle group ranges of main group range: {}", (Object)main);
        this.checkArgumentMainGroupRange(main);
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        if (xmlProject.getGroupAddressStyle() == XmlGroupAddressStyle.THREE_LEVEL) {
            XmlGroupRange mainRange = xmlProject.getGroupRange(main);
            this.log.debug("Main group range '{}' found: {}", (Object)main, (Object)mainRange);
            this.getResponse().ok();
            return this.limitAndGetAsList(mainRange.getChildGroupRanges());
        }
        this.getResponse().forbidden();
        return List.of();
    }

    @GET(value={"/project/addresses"})
    @Produces(value={"application/json"})
    public List<XmlGroupAddress> getGroupAddresses() {
        this.log.trace("Request all group addresses");
        this.getResponse().ok();
        return this.limitAndGetAsList(this.getKnxClient().getConfig().getProject().getGroupAddresses());
    }

    @GET(value={"/project/addresses/{main: \\d+}"})
    @Produces(value={"application/json"})
    public List<XmlGroupAddress> getGroupAddresses(@Param int main) {
        this.log.trace("Request addresses for main group range: {}", (Object)main);
        this.checkArgumentMainGroupRange(main);
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        if (xmlProject.getGroupAddressStyle() == XmlGroupAddressStyle.TWO_LEVEL) {
            XmlGroupRange middleGroup = xmlProject.getGroupRange(main);
            this.log.debug("Middle Group Range for main group range '{}' found: {}", (Object)main, (Object)middleGroup);
            this.getResponse().ok();
            return this.limitAndGetAsList(middleGroup.getGroupAddresses());
        }
        this.getResponse().forbidden();
        return List.of();
    }

    @GET(value={"/project/addresses/{main: \\d+}/{middle: \\d+}"})
    @Produces(value={"application/json"})
    public List<XmlGroupAddress> getGroupAddresses(@Param int main, @Param int middle) {
        this.log.trace("Request addresses for middle group: {}/{}", (Object)main, (Object)middle);
        this.checkArgumentMainGroupRange(main);
        this.checkArgumentMiddleGroupRange(middle);
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        if (xmlProject.getGroupAddressStyle() == XmlGroupAddressStyle.THREE_LEVEL) {
            XmlGroupRange middleGroup = xmlProject.getGroupRange(main, middle);
            this.log.debug("Middle Group Range for main group range '{}/{}' found: {}", new Object[]{main, middle, middleGroup});
            this.getResponse().ok();
            return this.limitAndGetAsList(middleGroup.getGroupAddresses());
        }
        this.getResponse().forbidden();
        return List.of();
    }

    private void checkArgumentMainGroupRange(int main) {
        Preconditions.checkArgument((main >= 0 && main <= 31 ? 1 : 0) != 0, (Object)"Invalid number of main group provided, should be within range [0-31]: {}", (Object[])new Object[]{main});
    }

    private void checkArgumentMiddleGroupRange(int middle) {
        Preconditions.checkArgument((middle >= 0 && middle <= 7 ? 1 : 0) != 0, (Object)"Invalid number of middle group provided, should be within range [0-7]: {}", (Object[])new Object[]{middle});
    }
}

