/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import li.pitschmann.knx.core.address.GroupAddress;
import li.pitschmann.knx.core.address.KnxAddress;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.communication.KnxStatusData;
import li.pitschmann.knx.core.datapoint.DataPointRegistry;
import li.pitschmann.knx.core.datapoint.DataPointType;
import li.pitschmann.knx.core.knxproj.XmlGroupAddress;
import li.pitschmann.knx.core.plugin.api.v1.controllers.AbstractController;
import li.pitschmann.knx.core.plugin.api.v1.json.ReadRequest;
import li.pitschmann.knx.core.plugin.api.v1.json.ReadResponse;
import ro.pippo.controller.Consumes;
import ro.pippo.controller.POST;
import ro.pippo.controller.Produces;
import ro.pippo.controller.extractor.Body;

public final class ReadRequestController
extends AbstractController {
    private static final ReadResponse EMPTY_RESPONSE = new ReadResponse();

    public ReadRequestController(KnxClient knxClient) {
        super(knxClient);
    }

    @POST(value={"/read"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ReadResponse readRequest(@Body ReadRequest readRequest) {
        this.log.trace("Http Read Request received: {}", (Object)readRequest);
        GroupAddress groupAddress = readRequest.getGroupAddress();
        if (groupAddress == null) {
            this.log.warn("Could not find group address in request.");
            this.getResponse().badRequest();
            return EMPTY_RESPONSE;
        }
        if (!this.getKnxClient().readRequest(groupAddress)) {
            this.log.warn("No or unexpected acknowledge received for read request: {}", (Object)readRequest);
            this.getResponse().internalError();
            return EMPTY_RESPONSE;
        }
        KnxStatusData knxStatusData = this.getKnxClient().getStatusPool().getStatusFor((KnxAddress)groupAddress);
        if (knxStatusData == null) {
            this.log.warn("Status data not found for group address: {}", (Object)groupAddress);
            this.getResponse().notFound();
            return EMPTY_RESPONSE;
        }
        this.log.debug("Status data found for group address: {}", (Object)groupAddress);
        ReadResponse response = new ReadResponse();
        response.setGroupAddress(groupAddress);
        response.setRaw(knxStatusData.getApciData());
        XmlGroupAddress xmlGroupAddress = this.getKnxClient().getConfig().getProject().getGroupAddress(groupAddress);
        if (xmlGroupAddress != null) {
            DataPointType dpt = DataPointRegistry.getDataPointType((String)xmlGroupAddress.getDataPointType());
            response.setName(xmlGroupAddress.getName());
            response.setDescription(xmlGroupAddress.getDescription());
            response.setDataPointType(dpt);
            response.setValue(dpt.of(knxStatusData.getApciData()).toText());
            response.setUnit(dpt.getUnit());
        } else {
            this.log.warn("Could not find group address in XML project: {}", (Object)groupAddress);
        }
        this.getResponse().ok();
        return response;
    }
}

