/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import li.pitschmann.knx.core.address.GroupAddress;
import li.pitschmann.knx.core.address.KnxAddress;
import li.pitschmann.knx.core.annotations.Nullable;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.communication.KnxStatusData;
import li.pitschmann.knx.core.datapoint.DataPointRegistry;
import li.pitschmann.knx.core.knxproj.XmlGroupAddress;
import li.pitschmann.knx.core.knxproj.XmlProject;
import li.pitschmann.knx.core.plugin.api.v1.controllers.AbstractController;
import li.pitschmann.knx.core.plugin.api.v1.json.Status;
import li.pitschmann.knx.core.plugin.api.v1.json.StatusResponse;
import ro.pippo.controller.GET;
import ro.pippo.controller.Produces;
import ro.pippo.controller.extractor.Param;

public final class StatusController
extends AbstractController {
    private static final StatusResponse EMPTY_RESPONSE = new StatusResponse();

    public StatusController(KnxClient knxClient) {
        super(knxClient);
    }

    @GET(value={"/status"})
    @Produces(value={"application/json"})
    public List<StatusResponse> statusAll() {
        this.log.trace("Http Status request for all available group addresses received");
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        Map statusMap = this.getKnxClient().getStatusPool().copyStatusMap();
        ArrayList<StatusResponse> responses = new ArrayList<StatusResponse>(statusMap.size());
        for (Map.Entry entry : statusMap.entrySet()) {
            if (!(entry.getKey() instanceof GroupAddress)) continue;
            GroupAddress groupAddress = (GroupAddress)entry.getKey();
            XmlGroupAddress xmlGroupAddress = xmlProject.getGroupAddress(groupAddress);
            StatusResponse response = new StatusResponse();
            if (xmlGroupAddress != null) {
                this.log.debug("Found group address in XML project: {}", (Object)groupAddress);
                this.fill(response, groupAddress, xmlGroupAddress, (KnxStatusData)entry.getValue());
            } else {
                this.fill(response, groupAddress, null, null);
            }
            responses.add(response);
        }
        this.getResponse().status(207);
        return this.limitAndGetAsList(responses);
    }

    @GET(value={"/status/{ga: \\d+(\\/\\d+)?(\\/\\d+)?}"})
    @Produces(value={"application/json"})
    public StatusResponse statusOne(@Param(value="ga") String groupAddressStr) {
        this.log.trace("Http Status Request received for: {}", (Object)groupAddressStr);
        GroupAddress groupAddress = GroupAddress.of((String)groupAddressStr);
        KnxStatusData knxStatusData = this.getKnxClient().getStatusPool().getStatusFor((KnxAddress)groupAddress);
        if (knxStatusData == null) {
            this.log.warn("Status data not found for group address: {}", (Object)groupAddress);
            this.getResponse().notFound();
            return EMPTY_RESPONSE;
        }
        StatusResponse response = new StatusResponse();
        XmlGroupAddress xmlGroupAddress = this.getKnxClient().getConfig().getProject().getGroupAddress(groupAddress);
        this.fill(response, groupAddress, xmlGroupAddress, knxStatusData);
        this.getResponse().ok();
        return response;
    }

    private void fill(StatusResponse response, GroupAddress groupAddress, @Nullable XmlGroupAddress xmlGroupAddress, @Nullable KnxStatusData knxStatusData) {
        if (knxStatusData != null) {
            response.setTimestamp(knxStatusData.getTimestamp());
            response.setSourceAddress(knxStatusData.getSourceAddress());
            response.setApci(knxStatusData.getApci());
            response.setRaw(knxStatusData.getApciData());
            response.setDirty(knxStatusData.isDirty());
        } else {
            this.log.warn("No status data found for group address: {}", (Object)groupAddress);
        }
        if (xmlGroupAddress != null) {
            response.setDataPointType(DataPointRegistry.getDataPointType((String)xmlGroupAddress.getDataPointType()));
            response.setName(xmlGroupAddress.getName());
            response.setDescription(xmlGroupAddress.getDescription());
        } else {
            this.log.warn("Could not find group address in XML project: {}", (Object)groupAddress);
        }
        response.setStatus(knxStatusData == null ? Status.ERROR : Status.OK);
        response.setGroupAddress(groupAddress);
    }
}

