/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api;

import java.util.Objects;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.plugin.api.gson.ApiGsonEngine;
import li.pitschmann.knx.core.plugin.api.v1.controllers.ProjectController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.ReadRequestController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.StatisticController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.StatusController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.WriteRequestController;
import ro.pippo.controller.Controller;
import ro.pippo.controller.ControllerApplication;
import ro.pippo.controller.GET;
import ro.pippo.controller.Produces;
import ro.pippo.core.ContentTypeEngine;

public class ApiApplication
extends ControllerApplication {
    private KnxClient knxClient;

    public ApiApplication(KnxClient knxClient) {
        this.knxClient = Objects.requireNonNull(knxClient);
    }

    protected void onInit() {
        this.getContentTypeEngines().setContentTypeEngine((ContentTypeEngine)ApiGsonEngine.INSTANCE);
        this.addControllers(new Controller[]{new HeartbeatController(), new ReadRequestController(this.knxClient), new WriteRequestController(this.knxClient), new StatusController(this.knxClient), new StatisticController(this.knxClient), new ProjectController(this.knxClient)});
    }

    public static final class HeartbeatController
    extends Controller {
        @GET(value={"/api/ping"})
        @Produces(value={"text/plain"})
        public String healthCheck() {
            this.getResponse().noCache().text().ok();
            return "OK";
        }
    }
}

