/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import li.pitschmann.knx.core.address.AddressType;
import li.pitschmann.knx.core.address.KnxAddress;
import li.pitschmann.knx.core.plugin.api.gson.GroupAddressJsonDeserializer;
import li.pitschmann.knx.core.plugin.api.gson.IndividualAddressJsonDeserializer;
import li.pitschmann.knx.core.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KnxAddressJsonDeserializer
implements JsonDeserializer<KnxAddress> {
    public static final KnxAddressJsonDeserializer INSTANCE = new KnxAddressJsonDeserializer();
    private static final Logger log = LoggerFactory.getLogger(KnxAddressJsonDeserializer.class);

    public KnxAddress deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        Preconditions.checkArgument((boolean)jsonElement.isJsonObject(), (Object)"JSON Element should be a JsonObject.", (Object[])new Object[0]);
        JsonObject jsonObject = (JsonObject)jsonElement;
        int addressType = jsonObject.getAsJsonPrimitive("type").getAsInt();
        log.debug("Address Type is: {}", (Object)addressType);
        if (addressType == AddressType.GROUP.getCode()) {
            return GroupAddressJsonDeserializer.INSTANCE.deserialize(jsonElement, type, jsonDeserializationContext);
        }
        if (addressType == AddressType.INDIVIDUAL.getCode()) {
            return IndividualAddressJsonDeserializer.INSTANCE.deserialize(jsonElement, type, jsonDeserializationContext);
        }
        throw new UnsupportedOperationException("Given JSON type is not supported: " + jsonElement);
    }
}

