/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import li.pitschmann.knx.core.address.GroupAddress;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.datapoint.DataPointType;
import li.pitschmann.knx.core.datapoint.value.DataPointValue;
import li.pitschmann.knx.core.plugin.api.v1.controllers.AbstractController;
import li.pitschmann.knx.core.plugin.api.v1.json.WriteRequest;
import li.pitschmann.knx.core.plugin.api.v1.json.WriteResponse;
import ro.pippo.controller.Consumes;
import ro.pippo.controller.POST;
import ro.pippo.controller.Produces;
import ro.pippo.controller.extractor.Body;

public final class WriteRequestController
extends AbstractController {
    private static final WriteResponse EMPTY_RESPONSE = new WriteResponse();

    public WriteRequestController(KnxClient knxClient) {
        super(knxClient);
    }

    @POST(value={"/write"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public WriteResponse writeRequest(@Body WriteRequest writeRequest) {
        DataPointValue value;
        this.log.trace("Http Write Request received: {}", (Object)writeRequest);
        GroupAddress groupAddress = writeRequest.getGroupAddress();
        if (groupAddress == null) {
            this.log.warn("Could not find group address in request.");
            this.getResponse().badRequest();
            return EMPTY_RESPONSE;
        }
        DataPointType dpt = writeRequest.getDataPointType();
        if (dpt == null) {
            this.log.error("Could not find suitable data point type in request.");
            this.getResponse().badRequest();
            return EMPTY_RESPONSE;
        }
        byte[] rawToWrite = writeRequest.getRaw();
        if (rawToWrite != null && rawToWrite.length > 0) {
            value = dpt.of(rawToWrite);
        } else {
            String[] dptValues = writeRequest.getValues();
            if (dptValues == null || dptValues.length == 0) {
                this.log.error("No DPT values defined for write request: {}", (Object)writeRequest);
                WriteResponse response = new WriteResponse();
                this.getResponse().badRequest();
                return response;
            }
            this.log.debug("DPT values received for write request: {}", (Object)writeRequest);
            value = dpt.of(dptValues);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Write request to group address '{}' with: {}", (Object)groupAddress, (Object)value);
        }
        if (this.getKnxClient().writeRequest(groupAddress, value)) {
            this.log.debug("Acknowledge received for write request: {}", (Object)writeRequest);
            this.getResponse().accepted();
        } else {
            this.log.warn("No or unexpected acknowledge received for write request: {}", (Object)writeRequest);
            this.getResponse().internalError();
        }
        return EMPTY_RESPONSE;
    }
}

