/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api;

import com.google.gson.Gson;
import io.javalin.Javalin;
import io.javalin.plugin.json.JavalinJson;
import java.util.Objects;
import li.pitschmann.knx.core.address.GroupAddress;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.config.ConfigValue;
import li.pitschmann.knx.core.plugin.ExtensionPlugin;
import li.pitschmann.knx.core.plugin.IntegerConfigValue;
import li.pitschmann.knx.core.plugin.api.v1.controllers.HeartbeatController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.ProjectController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.ReadRequestController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.StatisticController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.StatusController;
import li.pitschmann.knx.core.plugin.api.v1.controllers.WriteRequestController;
import li.pitschmann.knx.core.plugin.api.v1.gson.ApiGsonEngine;
import li.pitschmann.knx.core.plugin.api.v1.json.ReadRequest;
import li.pitschmann.knx.core.plugin.api.v1.json.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiPlugin
implements ExtensionPlugin {
    public static final IntegerConfigValue PORT = new IntegerConfigValue("port", () -> 8181, Objects::nonNull);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Javalin javalin = Javalin.create();
    private KnxClient client;
    private int serverPort;

    public void onInitialization(KnxClient client) {
        this.client = Objects.requireNonNull(client);
        this.serverPort = (Integer)client.getConfig((ConfigValue)PORT);
    }

    public void onStart() {
        this.javalin.start(this.serverPort);
        Gson gson = ApiGsonEngine.INSTANCE.getGson();
        JavalinJson.setFromJsonMapper((arg_0, arg_1) -> ((Gson)gson).fromJson(arg_0, arg_1));
        JavalinJson.setToJsonMapper(arg_0 -> ((Gson)gson).toJson(arg_0));
        HeartbeatController heartbeatController = new HeartbeatController(this.client);
        this.javalin.get("/api/v1/ping", heartbeatController::ping);
        ProjectController projectController = new ProjectController(this.client);
        this.javalin.get("/api/v1/project", projectController::projectStructure);
        this.javalin.get("/api/v1/project/ranges", projectController::getGroupRanges);
        this.javalin.get("/api/v1/project/ranges/:main", ctx -> {
            int main = Integer.parseInt(ctx.pathParam("main"));
            projectController.getGroupRanges(ctx, main);
        });
        this.javalin.get("/api/v1/project/addresses", projectController::getGroupAddresses);
        this.javalin.get("/api/v1/project/addresses/:main", ctx -> {
            int main = Integer.parseInt(ctx.pathParam("main"));
            projectController.getGroupAddresses(ctx, main);
        });
        this.javalin.get("/api/v1/project/addresses/:main/:middle", ctx -> {
            int main = Integer.parseInt(ctx.pathParam("main"));
            int middle = Integer.parseInt(ctx.pathParam("middle"));
            projectController.getGroupAddresses(ctx, main, middle);
        });
        ReadRequestController readRequestController = new ReadRequestController(this.client);
        this.javalin.post("/api/v1/read", ctx -> {
            ReadRequest readRequest = (ReadRequest)JavalinJson.fromJson((String)ctx.body(), ReadRequest.class);
            readRequestController.readRequest(ctx, readRequest);
        });
        StatisticController statisticController = new StatisticController(this.client);
        this.javalin.get("/api/v1/statistic", statisticController::getStatistic);
        StatusController statusController = new StatusController(this.client);
        this.javalin.get("/api/v1/status", statusController::statusAll);
        this.javalin.get("/api/v1/status/:address", ctx -> {
            Integer address = Integer.valueOf(ctx.pathParam("address"));
            statusController.statusOne(ctx, GroupAddress.of((int)address));
        });
        this.javalin.get("/api/v1/status/:main/:sub", ctx -> {
            Integer main = Integer.valueOf(ctx.pathParam("main"));
            Integer sub = Integer.valueOf(ctx.pathParam("sub"));
            statusController.statusOne(ctx, GroupAddress.of((int)main, (int)sub));
        });
        this.javalin.get("/api/v1/status/:main/:middle/:sub", ctx -> {
            Integer main = Integer.valueOf(ctx.pathParam("main"));
            Integer middle = Integer.valueOf(ctx.pathParam("middle"));
            Integer sub = Integer.valueOf(ctx.pathParam("sub"));
            statusController.statusOne(ctx, GroupAddress.of((int)main, (int)middle, (int)sub));
        });
        WriteRequestController writeRequestController = new WriteRequestController(this.client);
        this.javalin.post("/api/v1/write", ctx -> {
            WriteRequest writeRequest = (WriteRequest)JavalinJson.fromJson((String)ctx.body(), WriteRequest.class);
            writeRequestController.writeRequest(ctx, writeRequest);
        });
        this.log.debug("API Plugin and Web Server started at port {}: {}", (Object)this.serverPort, (Object)this.client);
    }

    public void onShutdown() {
        this.javalin.stop();
        this.log.debug("API Plugin and Web Server stopped.");
    }

    public final int getPort() {
        return this.serverPort;
    }
}

