/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import io.javalin.http.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractController {
    private static final Logger log = LoggerFactory.getLogger(AbstractController.class);
    private KnxClient knxClient;

    protected AbstractController(KnxClient knxClient) {
        this.knxClient = Objects.requireNonNull(knxClient);
    }

    protected final KnxClient getKnxClient() {
        return this.knxClient;
    }

    protected final <T> List<T> limitAndGetAsList(Context ctx, Collection<T> list) {
        int start = this.getIntParameter(ctx, "start", 0);
        int limit = this.getIntParameter(ctx, "limit", Integer.MAX_VALUE);
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"Start should be 0 or greater: {}", (Object[])new Object[]{start});
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Limit should be 0 or greater: {}", (Object[])new Object[]{limit});
        if (start == 0 && limit == Integer.MAX_VALUE) {
            log.trace("No range defined.");
            return new ArrayList<T>(list);
        }
        log.trace("Range defined: start={}, limit={}", (Object)start, (Object)limit);
        return list.stream().skip(start).limit(limit).collect(Collectors.toList());
    }

    private int getIntParameter(Context ctx, String parameterName, int defaultValue) {
        List strValues = (List)ctx.queryParamMap().get(parameterName);
        if (strValues == null || strValues.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt((String)strValues.get(0));
    }
}

