/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import io.javalin.http.Context;
import java.util.Collections;
import java.util.List;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.knxproj.XmlGroupAddressStyle;
import li.pitschmann.knx.core.knxproj.XmlGroupRange;
import li.pitschmann.knx.core.knxproj.XmlProject;
import li.pitschmann.knx.core.plugin.api.v1.controllers.AbstractController;
import li.pitschmann.knx.core.plugin.api.v1.json.ProjectStructureResponse;
import li.pitschmann.knx.core.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProjectController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(ProjectController.class);

    public ProjectController(KnxClient knxClient) {
        super(knxClient);
    }

    public void projectStructure(Context ctx) {
        log.trace("Request for project overview");
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        if (xmlProject == null) {
            log.error("No project file found.");
            ctx.status(404);
            ctx.result("");
            return;
        }
        ProjectStructureResponse response = new ProjectStructureResponse();
        response.setId(xmlProject.getId());
        response.setName(xmlProject.getName());
        response.setGroupAddressStyle(xmlProject.getGroupAddressStyle().getCode());
        response.setVersion(xmlProject.getVersion());
        response.setNumberOfGroupRanges(xmlProject.getGroupRanges().size());
        response.setNumberOfGroupAddresses(xmlProject.getGroupAddresses().size());
        ctx.status(200);
        ctx.json((Object)response);
    }

    public void getGroupRanges(Context ctx) {
        log.trace("Request for all main group ranges in project");
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        XmlGroupAddressStyle groupAddressStyle = xmlProject.getGroupAddressStyle();
        if (groupAddressStyle == XmlGroupAddressStyle.THREE_LEVEL || groupAddressStyle == XmlGroupAddressStyle.TWO_LEVEL) {
            List mainRanges = xmlProject.getMainGroupRanges();
            log.debug("All main group ranges found: {}", (Object)mainRanges);
            List list = this.limitAndGetAsList(ctx, mainRanges);
            ctx.status(200);
            ctx.json(list);
        } else {
            ctx.status(403);
            ctx.json(Collections.emptyList());
        }
    }

    public void getGroupRanges(Context ctx, int main) {
        log.trace("Request for middle group ranges of main group range: {}", (Object)main);
        this.checkArgumentMainGroupRange(main);
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        if (xmlProject.getGroupAddressStyle() == XmlGroupAddressStyle.THREE_LEVEL) {
            XmlGroupRange mainRange = xmlProject.getGroupRange(main);
            log.debug("Main group range '{}' found: {}", (Object)main, (Object)mainRange);
            List list = this.limitAndGetAsList(ctx, mainRange.getChildGroupRanges());
            ctx.status(200);
            ctx.json(list);
        } else {
            ctx.status(403);
            ctx.json(List.of());
        }
    }

    public void getGroupAddresses(Context ctx) {
        log.trace("Request all group addresses");
        List list = this.limitAndGetAsList(ctx, this.getKnxClient().getConfig().getProject().getGroupAddresses());
        ctx.status(200);
        ctx.json(list);
    }

    public void getGroupAddresses(Context ctx, int main) {
        log.trace("Request addresses for main group range: {}", (Object)main);
        this.checkArgumentMainGroupRange(main);
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        if (xmlProject.getGroupAddressStyle() == XmlGroupAddressStyle.TWO_LEVEL) {
            XmlGroupRange middleGroup = xmlProject.getGroupRange(main);
            log.debug("Middle Group Range for main group range '{}' found: {}", (Object)main, (Object)middleGroup);
            List list = this.limitAndGetAsList(ctx, middleGroup.getGroupAddresses());
            ctx.status(200);
            ctx.json(list);
        } else {
            ctx.status(403);
            ctx.json(List.of());
        }
    }

    public void getGroupAddresses(Context ctx, int main, int middle) {
        log.trace("Request addresses for middle group: {}/{}", (Object)main, (Object)middle);
        this.checkArgumentMainGroupRange(main);
        this.checkArgumentMiddleGroupRange(middle);
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        if (xmlProject.getGroupAddressStyle() == XmlGroupAddressStyle.THREE_LEVEL) {
            XmlGroupRange middleGroup = xmlProject.getGroupRange(main, middle);
            log.debug("Middle Group Range for main group range '{}/{}' found: {}", new Object[]{main, middle, middleGroup});
            List list = this.limitAndGetAsList(ctx, middleGroup.getGroupAddresses());
            ctx.status(200);
            ctx.json(list);
        } else {
            ctx.status(403);
            ctx.json(List.of());
        }
    }

    private void checkArgumentMainGroupRange(int main) {
        Preconditions.checkArgument((main >= 0 && main <= 31 ? 1 : 0) != 0, (Object)"Invalid number of main group provided, should be within range [0-31]: {}", (Object[])new Object[]{main});
    }

    private void checkArgumentMiddleGroupRange(int middle) {
        Preconditions.checkArgument((middle >= 0 && middle <= 7 ? 1 : 0) != 0, (Object)"Invalid number of middle group provided, should be within range [0-7]: {}", (Object[])new Object[]{middle});
    }
}

