/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import io.javalin.http.Context;
import li.pitschmann.knx.core.address.GroupAddress;
import li.pitschmann.knx.core.address.KnxAddress;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.communication.KnxStatusData;
import li.pitschmann.knx.core.datapoint.DataPointRegistry;
import li.pitschmann.knx.core.datapoint.DataPointType;
import li.pitschmann.knx.core.knxproj.XmlGroupAddress;
import li.pitschmann.knx.core.plugin.api.v1.controllers.AbstractController;
import li.pitschmann.knx.core.plugin.api.v1.json.ReadRequest;
import li.pitschmann.knx.core.plugin.api.v1.json.ReadResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadRequestController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(ReadRequestController.class);
    private static final ReadResponse EMPTY_RESPONSE = new ReadResponse();

    public ReadRequestController(KnxClient knxClient) {
        super(knxClient);
    }

    public void readRequest(Context ctx, ReadRequest readRequest) {
        log.trace("Http Read Request received: {}", (Object)readRequest);
        GroupAddress groupAddress = readRequest.getGroupAddress();
        if (groupAddress == null) {
            log.warn("Could not find group address in request.");
            ctx.status(400);
            ctx.json((Object)EMPTY_RESPONSE);
            return;
        }
        if (!this.getKnxClient().readRequest(groupAddress, 3000L)) {
            log.warn("No or unexpected acknowledge received for read request: {}", (Object)readRequest);
            ctx.status(500);
            ctx.json((Object)EMPTY_RESPONSE);
            return;
        }
        KnxStatusData knxStatusData = this.getKnxClient().getStatusPool().getStatusFor((KnxAddress)groupAddress);
        if (knxStatusData == null) {
            log.warn("Status data not found for group address: {}", (Object)groupAddress);
            ctx.status(404);
            ctx.json((Object)EMPTY_RESPONSE);
            return;
        }
        log.debug("Status data found for group address: {}", (Object)groupAddress);
        ReadResponse response = new ReadResponse();
        response.setGroupAddress(groupAddress);
        response.setRaw(knxStatusData.getData());
        XmlGroupAddress xmlGroupAddress = this.getKnxClient().getConfig().getProject().getGroupAddress(groupAddress);
        if (xmlGroupAddress != null) {
            DataPointType dpt = DataPointRegistry.getDataPointType((String)xmlGroupAddress.getDataPointType());
            response.setName(xmlGroupAddress.getName());
            response.setDescription(xmlGroupAddress.getDescription());
            response.setDataPointType(dpt);
            response.setValue(dpt.of(knxStatusData.getData()).toText());
            response.setUnit(dpt.getUnit());
        } else {
            log.warn("Could not find group address in XML project: {}", (Object)groupAddress);
        }
        ctx.status(200);
        ctx.json((Object)response);
    }
}

