/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import io.javalin.http.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import li.pitschmann.knx.core.address.GroupAddress;
import li.pitschmann.knx.core.address.KnxAddress;
import li.pitschmann.knx.core.annotations.Nullable;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.communication.KnxStatusData;
import li.pitschmann.knx.core.datapoint.DataPointRegistry;
import li.pitschmann.knx.core.knxproj.XmlGroupAddress;
import li.pitschmann.knx.core.knxproj.XmlProject;
import li.pitschmann.knx.core.plugin.api.v1.controllers.AbstractController;
import li.pitschmann.knx.core.plugin.api.v1.json.Status;
import li.pitschmann.knx.core.plugin.api.v1.json.StatusResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatusController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(StatusController.class);
    private static final StatusResponse EMPTY_RESPONSE = new StatusResponse();

    public StatusController(KnxClient knxClient) {
        super(knxClient);
    }

    public void statusAll(Context ctx) {
        log.trace("Http Status request for all available group addresses received");
        XmlProject xmlProject = this.getKnxClient().getConfig().getProject();
        Map statusMap = this.getKnxClient().getStatusPool().copyStatusMap();
        ArrayList<StatusResponse> responses = new ArrayList<StatusResponse>(statusMap.size());
        for (Map.Entry entry : statusMap.entrySet()) {
            if (!(entry.getKey() instanceof GroupAddress)) continue;
            GroupAddress groupAddress = (GroupAddress)entry.getKey();
            XmlGroupAddress xmlGroupAddress = xmlProject.getGroupAddress(groupAddress);
            StatusResponse response = new StatusResponse();
            if (xmlGroupAddress != null) {
                log.debug("Found group address in XML project: {}", (Object)groupAddress);
                this.fill(response, groupAddress, xmlGroupAddress, (KnxStatusData)entry.getValue());
            } else {
                this.fill(response, groupAddress, null, null);
            }
            responses.add(response);
        }
        List list = this.limitAndGetAsList(ctx, responses);
        ctx.status(207);
        ctx.json(list);
    }

    public void statusOne(Context ctx, GroupAddress groupAddress) {
        log.trace("Http Status Request received for: {}", (Object)groupAddress);
        KnxStatusData knxStatusData = this.getKnxClient().getStatusPool().getStatusFor((KnxAddress)groupAddress);
        if (knxStatusData == null) {
            log.warn("Status data not found for group address: {}", (Object)groupAddress);
            ctx.status(404);
            ctx.json((Object)EMPTY_RESPONSE);
            return;
        }
        StatusResponse response = new StatusResponse();
        XmlGroupAddress xmlGroupAddress = this.getKnxClient().getConfig().getProject().getGroupAddress(groupAddress);
        this.fill(response, groupAddress, xmlGroupAddress, knxStatusData);
        ctx.status(200);
        ctx.json((Object)response);
    }

    private void fill(StatusResponse response, GroupAddress groupAddress, @Nullable XmlGroupAddress xmlGroupAddress, @Nullable KnxStatusData knxStatusData) {
        if (knxStatusData != null) {
            response.setTimestamp(knxStatusData.getTimestamp());
            response.setSourceAddress(knxStatusData.getSourceAddress());
            response.setApci(knxStatusData.getAPCI());
            response.setRaw(knxStatusData.getData());
            response.setDirty(knxStatusData.isDirty());
        } else {
            log.warn("No status data found for group address: {}", (Object)groupAddress);
        }
        if (xmlGroupAddress != null) {
            response.setDataPointType(DataPointRegistry.getDataPointType((String)xmlGroupAddress.getDataPointType()));
            response.setName(xmlGroupAddress.getName());
            response.setDescription(xmlGroupAddress.getDescription());
        } else {
            log.warn("Could not find group address in XML project: {}", (Object)groupAddress);
        }
        response.setStatus(knxStatusData == null ? Status.ERROR : Status.OK);
        response.setGroupAddress(groupAddress);
    }
}

