/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.controllers;

import io.javalin.http.Context;
import li.pitschmann.knx.core.address.GroupAddress;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.datapoint.DataPointType;
import li.pitschmann.knx.core.datapoint.value.DataPointValue;
import li.pitschmann.knx.core.plugin.api.v1.controllers.AbstractController;
import li.pitschmann.knx.core.plugin.api.v1.json.WriteRequest;
import li.pitschmann.knx.core.plugin.api.v1.json.WriteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteRequestController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(WriteRequestController.class);
    private static final WriteResponse EMPTY_RESPONSE = new WriteResponse();

    public WriteRequestController(KnxClient knxClient) {
        super(knxClient);
    }

    public void writeRequest(Context ctx, WriteRequest writeRequest) {
        DataPointValue value;
        log.trace("Http Write Request received: {}", (Object)writeRequest);
        GroupAddress groupAddress = writeRequest.getGroupAddress();
        if (groupAddress == null) {
            log.warn("Could not find group address in request.");
            ctx.status(400);
            ctx.json((Object)EMPTY_RESPONSE);
            return;
        }
        DataPointType dpt = writeRequest.getDataPointType();
        if (dpt == null) {
            log.error("Could not find suitable data point type in request.");
            ctx.status(400);
            ctx.json((Object)EMPTY_RESPONSE);
            return;
        }
        byte[] rawToWrite = writeRequest.getRaw();
        if (rawToWrite != null && rawToWrite.length > 0) {
            value = dpt.of(rawToWrite);
        } else {
            String[] dptValues = writeRequest.getValues();
            if (dptValues == null || dptValues.length == 0) {
                log.error("No DPT values defined for write request: {}", (Object)writeRequest);
                WriteResponse response = new WriteResponse();
                ctx.status(400);
                ctx.json((Object)response);
                return;
            }
            log.debug("DPT values received for write request: {}", (Object)writeRequest);
            value = dpt.of(dptValues);
        }
        if (log.isDebugEnabled()) {
            log.debug("Write request to group address '{}' with: {}", (Object)groupAddress, (Object)value);
        }
        if (this.getKnxClient().writeRequest(groupAddress, value, 3000L)) {
            log.debug("Acknowledge received for write request: {}", (Object)writeRequest);
            ctx.status(202);
            ctx.json((Object)EMPTY_RESPONSE);
        } else {
            log.warn("No or unexpected acknowledge received for write request: {}", (Object)writeRequest);
            ctx.status(500);
            ctx.json((Object)EMPTY_RESPONSE);
        }
    }
}

