/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import li.pitschmann.knx.core.address.AddressType;
import li.pitschmann.knx.core.address.KnxAddress;
import li.pitschmann.knx.core.utils.Preconditions;

public abstract class AbstractKnxAddressJsonDeserializer<T extends KnxAddress>
implements JsonDeserializer<T> {
    public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            Preconditions.checkArgument((jsonObject.getAsJsonPrimitive("type").getAsInt() == this.supportedAddressType().getCode() ? 1 : 0) != 0, (Object)"The type of KnxAddress format is not supported!", (Object[])new Object[0]);
            return this.convert(this.convertJsonArrayToByteArray(jsonObject.getAsJsonArray("raw")));
        }
        if (jsonElement.isJsonArray()) {
            return this.convert(this.convertJsonArrayToByteArray(jsonElement.getAsJsonArray()));
        }
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isString()) {
                return this.convert(jsonPrimitive.getAsString());
            }
            if (jsonPrimitive.isNumber()) {
                return this.convert(String.valueOf(jsonPrimitive.getAsInt()));
            }
        }
        throw new UnsupportedOperationException("Given JSON format is not supported: " + jsonElement);
    }

    private byte[] convertJsonArrayToByteArray(JsonArray jsonArray) {
        byte[] array = new byte[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = jsonArray.get(i).getAsByte();
        }
        return array;
    }

    protected abstract AddressType supportedAddressType();

    protected abstract T convert(byte[] var1);

    protected abstract T convert(String var1);
}

