/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.api.v1.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import li.pitschmann.knx.core.address.GroupAddress;
import li.pitschmann.knx.core.datapoint.DataPointRegistry;
import li.pitschmann.knx.core.datapoint.DataPointType;
import li.pitschmann.knx.core.knxproj.XmlGroupAddress;
import li.pitschmann.knx.core.plugin.api.v1.gson.DataPointTypeJsonSerializer;
import li.pitschmann.knx.core.plugin.api.v1.gson.GroupAddressJsonSerializer;
import li.pitschmann.knx.core.utils.Strings;

public final class XmlGroupAddressJsonSerializer
implements JsonSerializer<XmlGroupAddress> {
    public static final XmlGroupAddressJsonSerializer INSTANCE = new XmlGroupAddressJsonSerializer();

    private XmlGroupAddressJsonSerializer() {
    }

    public JsonElement serialize(XmlGroupAddress src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("id", src.getId());
        json.addProperty("name", src.getName());
        json.addProperty("description", src.getDescription());
        GroupAddress groupAddress = GroupAddress.of((String)src.getAddress());
        JsonElement groupAddressJson = GroupAddressJsonSerializer.INSTANCE.serialize(groupAddress, typeOfSrc, context);
        json.add("address", groupAddressJson);
        String dataPointTypeStr = src.getDataPointType();
        if (!Strings.isNullOrEmpty((String)dataPointTypeStr)) {
            DataPointType dpt = DataPointRegistry.getDataPointType((String)dataPointTypeStr);
            JsonElement dptJson = DataPointTypeJsonSerializer.INSTANCE.serialize(dpt, typeOfSrc, context);
            json.add("dataPointType", dptJson);
        }
        return json;
    }
}

