/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.audit;

import com.vlkan.rfos.RotatingFileOutputStream;
import com.vlkan.rfos.RotationCallback;
import com.vlkan.rfos.RotationConfig;
import com.vlkan.rfos.policy.DailyRotationPolicy;
import com.vlkan.rfos.policy.RotationPolicy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import li.pitschmann.knx.core.body.Body;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.config.ConfigValue;
import li.pitschmann.knx.core.header.Header;
import li.pitschmann.knx.core.plugin.EnumConfigValue;
import li.pitschmann.knx.core.plugin.ExtensionPlugin;
import li.pitschmann.knx.core.plugin.ObserverPlugin;
import li.pitschmann.knx.core.plugin.PathConfigValue;
import li.pitschmann.knx.core.plugin.audit.FileAuditFormat;
import li.pitschmann.knx.core.plugin.audit.HeaderRotationCallback;
import li.pitschmann.knx.core.utils.ByteFormatter;
import li.pitschmann.knx.core.utils.Closeables;
import li.pitschmann.knx.core.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileAuditPlugin
implements ObserverPlugin,
ExtensionPlugin {
    public static final PathConfigValue PATH = new PathConfigValue("path", () -> Paths.get("knx-audit.log", new String[0]), null);
    public static final EnumConfigValue<FileAuditFormat> FORMAT = new EnumConfigValue("format", FileAuditFormat.class, () -> FileAuditFormat.JSON);
    private static final Logger log = LoggerFactory.getLogger(FileAuditPlugin.class);
    private static final String FILE_ROLLOVER_PATTERN = "-%d{yyyyMMdd-HHmmss-SSS}";
    private Path path;
    private FileAuditFormat format;
    private RotatingFileOutputStream fos;

    public void onInitialization(KnxClient client) {
        this.path = (Path)client.getConfig((ConfigValue)PATH);
        this.format = (FileAuditFormat)((Object)client.getConfig(FORMAT));
        log.info("Initialized '{}' with: [path={}, format={}]", new Object[]{this.getClass().getName(), this.path, this.format});
        String baseFile = this.path.toString();
        int lastExtensionDotPosition = baseFile.lastIndexOf(46);
        String rolloverFile = new StringBuilder().append(baseFile, 0, lastExtensionDotPosition).append(FILE_ROLLOVER_PATTERN).append(baseFile.substring(lastExtensionDotPosition)).toString();
        RotationConfig.Builder config = RotationConfig.builder().file(baseFile).filePattern(rolloverFile).policy((RotationPolicy)DailyRotationPolicy.getInstance()).append(false);
        String header = this.format.getHeader();
        if (!Strings.isNullOrEmpty((String)header)) {
            config.callback((RotationCallback)new HeaderRotationCallback(header));
        }
        this.fos = new RotatingFileOutputStream(config.build());
        this.auditSignal(AuditType.INIT);
    }

    public void onStart() {
        this.auditSignal(AuditType.START);
    }

    public void onShutdown() {
        this.auditSignal(AuditType.SHUTDOWN);
        Closeables.closeQuietly((AutoCloseable)this.fos);
    }

    public void onIncomingBody(Body item) {
        this.auditBody(AuditType.INCOMING, item);
    }

    public void onOutgoingBody(Body item) {
        this.auditBody(AuditType.OUTGOING, item);
    }

    public void onError(Throwable throwable) {
        Instant now = Instant.now();
        this.writeToAuditFile(String.format(this.format.getErrorTemplate(), now.getEpochSecond(), now.getNano(), this.format.escape((Object)AuditType.ERROR), this.format.escape(throwable.getMessage()), this.format.escape(throwable.getStackTrace())));
    }

    private void auditBody(AuditType type, Body body) {
        Instant now = Instant.now();
        Header header = Header.of((Body)body);
        this.writeToAuditFile(String.format(this.format.getBodyTemplate(), now.getEpochSecond(), now.getNano(), this.format.escape((Object)type), this.format.escape(header.getTotalLength()), this.format.escape(header.getRawDataAsHexString()), this.format.escape(ByteFormatter.formatHexAsString((byte[])body.getServiceType().getCodeAsBytes())), this.format.escape(body.getServiceType().name()), this.format.escape(body.getRawDataAsHexString())));
    }

    private void auditSignal(AuditType type) {
        Instant now = Instant.now();
        this.writeToAuditFile(String.format(this.format.getSignalTemplate(), now.getEpochSecond(), now.getNano(), this.format.escape((Object)type)));
    }

    private void writeToAuditFile(String line) {
        try {
            this.fos.write(line.getBytes(StandardCharsets.UTF_8));
            this.fos.write(System.lineSeparator().getBytes());
        }
        catch (IOException e) {
            log.error("Error writing to audit file '{}': {}", new Object[]{this.path, line, e});
        }
    }

    private static enum AuditType {
        INIT("init"),
        START("start"),
        SHUTDOWN("shutdown"),
        INCOMING("incoming"),
        OUTGOING("outgoing"),
        ERROR("error");

        private final String type;

        private AuditType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

