/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.audit;

import java.util.Arrays;
import java.util.function.Function;
import li.pitschmann.knx.core.annotations.Nullable;
import li.pitschmann.knx.core.utils.Json;

public enum FileAuditFormat {
    JSON("", "{\"datetime\":\"%1$s\",\"type\":%2$s}", "{\"datetime\":\"%1$s\",\"type\":%2$s,\"header\":{\"totalLength\":%3$s,\"raw\":%4$s},\"body\":{\"service\":{\"code\":%5$s,\"text\":%6$s},\"raw\":%7$s}}", "{\"datetime\":\"%1$s\",\"type\":%2$s,\"message\":%3$s,\"stacktrace\":%4$s}", Json::toJson),
    TSV("Date & Time\tType\tHeader Total Length\tHeader Raw\tBody Service Code\tBody Service Text\tBody Raw\tError Message\tError Stack Trace", "%1$s\t%2$s", "%1$s\t%2$s\t%3$s\t%4$s\t%5$s\t%6$s\t%7$s", "%1$s\t%2$s\t\t\t\t\t\t%3$s\t%4$s", obj -> (obj instanceof Object[] ? Arrays.toString((Object[])obj) : String.valueOf(obj)).replace("\t", ""));

    private final String header;
    private final String signalTemplate;
    private final String bodyTemplate;
    private final String errorTemplate;
    private final Function<Object, String> escaper;

    private FileAuditFormat(String header, String signalTemplate, String bodyTemplate, String errorTemplate, Function<Object, String> escaper) {
        this.header = header;
        this.signalTemplate = signalTemplate;
        this.bodyTemplate = bodyTemplate;
        this.errorTemplate = errorTemplate;
        this.escaper = escaper;
    }

    public String getHeader() {
        return this.header;
    }

    public String getSignalTemplate() {
        return this.signalTemplate;
    }

    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    public String getErrorTemplate() {
        return this.errorTemplate;
    }

    public String escape(@Nullable Object str) {
        return str == null ? "" : this.escaper.apply(str);
    }
}

