/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.audit;

import com.vlkan.rfos.RotationCallback;
import com.vlkan.rfos.policy.RotationPolicy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import li.pitschmann.knx.core.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HeaderRotationCallback
implements RotationCallback {
    private static final Logger log = LoggerFactory.getLogger(HeaderRotationCallback.class);
    private byte[] headerLineAsBytes;

    HeaderRotationCallback(String headerLine) {
        this.headerLineAsBytes = Bytes.concat((byte[][])new byte[][]{headerLine.getBytes(StandardCharsets.UTF_8), System.lineSeparator().getBytes(StandardCharsets.UTF_8)});
    }

    private static boolean isFileEmpty(OutputStream outputStream) {
        if (outputStream instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)outputStream;
            try {
                return fileOutputStream.getChannel().size() == 0L;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return false;
    }

    public void onTrigger(RotationPolicy rotationPolicy, Instant instant) {
    }

    public void onOpen(RotationPolicy rotationPolicy, Instant instant, OutputStream outputStream) {
        if (HeaderRotationCallback.isFileEmpty(outputStream)) {
            try {
                outputStream.write(this.headerLineAsBytes);
            }
            catch (IOException ex) {
                log.error("Something went wrong writing the header. Permission issue?", (Throwable)ex);
            }
        }
    }

    public void onClose(RotationPolicy rotationPolicy, Instant instant, OutputStream outputStream) {
    }

    public void onSuccess(RotationPolicy rotationPolicy, Instant instant, File file) {
    }

    public void onFailure(RotationPolicy rotationPolicy, Instant instant, File file, Exception e) {
    }
}

