/*
 * Decompiled with CFR 0.152.
 */
package li.pitschmann.knx.core.plugin.statistic;

import com.vlkan.rfos.RotatingFileOutputStream;
import com.vlkan.rfos.RotationCallback;
import com.vlkan.rfos.RotationConfig;
import com.vlkan.rfos.policy.DailyRotationPolicy;
import com.vlkan.rfos.policy.RotationPolicy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import li.pitschmann.knx.core.body.ConnectRequestBody;
import li.pitschmann.knx.core.body.ConnectResponseBody;
import li.pitschmann.knx.core.body.ConnectionStateRequestBody;
import li.pitschmann.knx.core.body.ConnectionStateResponseBody;
import li.pitschmann.knx.core.body.DescriptionRequestBody;
import li.pitschmann.knx.core.body.DescriptionResponseBody;
import li.pitschmann.knx.core.body.DisconnectRequestBody;
import li.pitschmann.knx.core.body.DisconnectResponseBody;
import li.pitschmann.knx.core.body.RoutingIndicationBody;
import li.pitschmann.knx.core.body.SearchRequestBody;
import li.pitschmann.knx.core.body.SearchResponseBody;
import li.pitschmann.knx.core.body.TunnelingAckBody;
import li.pitschmann.knx.core.body.TunnelingRequestBody;
import li.pitschmann.knx.core.communication.KnxClient;
import li.pitschmann.knx.core.communication.KnxStatistic;
import li.pitschmann.knx.core.config.ConfigValue;
import li.pitschmann.knx.core.plugin.EnumConfigValue;
import li.pitschmann.knx.core.plugin.ExtensionPlugin;
import li.pitschmann.knx.core.plugin.LongConfigValue;
import li.pitschmann.knx.core.plugin.PathConfigValue;
import li.pitschmann.knx.core.plugin.statistic.FileStatisticFormat;
import li.pitschmann.knx.core.plugin.statistic.HeaderRotationCallback;
import li.pitschmann.knx.core.utils.Closeables;
import li.pitschmann.knx.core.utils.Executors;
import li.pitschmann.knx.core.utils.Sleeper;
import li.pitschmann.knx.core.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileStatisticPlugin
implements ExtensionPlugin {
    public static final PathConfigValue PATH = new PathConfigValue("path", () -> Paths.get("knx-statistic.log", new String[0]), null);
    public static final EnumConfigValue<FileStatisticFormat> FORMAT = new EnumConfigValue("format", FileStatisticFormat.class, () -> FileStatisticFormat.JSON);
    public static final LongConfigValue INTERVAL_MS = new LongConfigValue("intervalMs", () -> 300000L, x -> x >= 10000L);
    private static final Logger log = LoggerFactory.getLogger(FileStatisticPlugin.class);
    private static final String FILE_ROLLOVER_PATTERN = "-%d{yyyyMMdd}";
    private final ExecutorService executor = Executors.newSingleThreadExecutor((boolean)true);
    private KnxClient client;
    private Path path;
    private FileStatisticFormat format;
    private RotatingFileOutputStream fos;

    public void onInitialization(KnxClient client) {
        this.path = (Path)client.getConfig((ConfigValue)PATH);
        this.format = (FileStatisticFormat)((Object)client.getConfig(FORMAT));
        Long intervalMs = (Long)client.getConfig((ConfigValue)INTERVAL_MS);
        log.info("Initialized '{}' with: [path={}, format={}, intervalMs={}]", new Object[]{this.getClass().getName(), this.path, this.format, intervalMs});
        String baseFile = this.path.toString();
        int lastExtensionDotPosition = baseFile.lastIndexOf(46);
        String rolloverFile = new StringBuilder().append(baseFile, 0, lastExtensionDotPosition).append(FILE_ROLLOVER_PATTERN).append(baseFile.substring(lastExtensionDotPosition)).toString();
        RotationConfig.Builder config = RotationConfig.builder().file(baseFile).filePattern(rolloverFile).policy((RotationPolicy)DailyRotationPolicy.getInstance()).append(true);
        String header = this.format.getHeader();
        if (!Strings.isNullOrEmpty((String)header)) {
            config.callback((RotationCallback)new HeaderRotationCallback(header));
        }
        this.fos = new RotatingFileOutputStream(config.build());
        this.client = Objects.requireNonNull(client);
        this.executor.execute(new FileStatisticIntervalWriter(intervalMs));
        this.executor.shutdown();
    }

    public void onStart() {
    }

    public void onShutdown() {
        Closeables.shutdownQuietly((ExecutorService)this.executor);
        this.writeToStatisticFile();
        Closeables.closeQuietly((AutoCloseable)this.fos);
    }

    private void writeToStatisticFile() {
        KnxStatistic statistics = this.client.getStatistic();
        String statisticsFormatted = String.format(this.format.getTemplate(), Instant.now(), statistics.getNumberOfBodyReceived(), statistics.getNumberOfBytesReceived(), statistics.getNumberOfBodySent(), statistics.getNumberOfBytesSent(), statistics.getNumberOfErrors(), statistics.getErrorRate(), statistics.getNumberOfBodyReceived(SearchRequestBody.class), statistics.getNumberOfBodyReceived(SearchResponseBody.class), statistics.getNumberOfBodySent(SearchRequestBody.class), statistics.getNumberOfBodySent(SearchResponseBody.class), statistics.getNumberOfBodyReceived(DescriptionResponseBody.class), statistics.getNumberOfBodySent(DescriptionRequestBody.class), statistics.getNumberOfBodyReceived(ConnectResponseBody.class), statistics.getNumberOfBodySent(ConnectRequestBody.class), statistics.getNumberOfBodyReceived(ConnectionStateResponseBody.class), statistics.getNumberOfBodySent(ConnectionStateRequestBody.class), statistics.getNumberOfBodyReceived(TunnelingRequestBody.class), statistics.getNumberOfBodyReceived(TunnelingAckBody.class), statistics.getNumberOfBodySent(TunnelingRequestBody.class), statistics.getNumberOfBodySent(TunnelingAckBody.class), statistics.getNumberOfBodyReceived(DisconnectRequestBody.class), statistics.getNumberOfBodyReceived(DisconnectResponseBody.class), statistics.getNumberOfBodySent(DisconnectRequestBody.class), statistics.getNumberOfBodySent(DisconnectResponseBody.class), statistics.getNumberOfBodyReceived(RoutingIndicationBody.class), statistics.getNumberOfBodySent(RoutingIndicationBody.class));
        try {
            this.fos.write(statisticsFormatted.getBytes(StandardCharsets.UTF_8));
            this.fos.write(System.lineSeparator().getBytes());
        }
        catch (IOException e) {
            log.error("Error writing to audit file '{}': {}", new Object[]{this.path, statisticsFormatted, e});
        }
    }

    private class FileStatisticIntervalWriter
    implements Runnable {
        private final long intervalMs;

        private FileStatisticIntervalWriter(long intervalMilliseconds) {
            this.intervalMs = intervalMilliseconds;
        }

        @Override
        public void run() {
            do {
                FileStatisticPlugin.this.writeToStatisticFile();
            } while (Sleeper.milliseconds((long)this.intervalMs));
        }
    }
}

