package li.rudin.arduino.api.cache;

public interface KeyValueCache
{
	/**
	 * Puts a value in the cache
	 * @param key
	 * @param value
	 */
	void put(String key, String value);
	
	/**
	 * Returns true, if cached and valid
	 * @param key
	 * @return
	 */
	boolean isCached(String key);
	
	/**
	 * Returns a cached key
	 * @param key
	 * @return
	 */
	String get(String key);
	
	/**
	 * Invalidates the cache
	 */
	void invalidate();
}
