package li.rudin.arduino.api.cdi;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.enterprise.util.Nonbinding;
import javax.inject.Qualifier;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
@Qualifier
public @interface Connection
{
	/**
	 * The host to connect to, if any
	 * @return
	 */
	@Nonbinding
	String host() default "";
	
	/**
	 * The port to connect to, if any
	 * @return
	 */
	@Nonbinding
	int port() default 2000;
	
	/**
	 * The Serial port, if any
	 * @return
	 */
	String serialPort() default "";
	
	/**
	 * Serial speed, if any
	 * @return
	 */
	int serialSpeed() default 115200;
}
