package li.rudin.arduino.api.cdi;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.inject.Qualifier;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
@Qualifier
public @interface DeviceEvent
{
	/**
	 * The device which emits the event
	 * @return
	 */
	Class<?> device();
	
	/**
	 * The event key
	 * @return
	 */
	String key() default "";
	
	/**
	 * Communication direction
	 * @return
	 */
	Direction direction() default Direction.INCOMING;
}
