package li.rudin.arduino.api.message;

import java.io.IOException;

public class Message
{

	public static final String OUTER_DELIM = "\n";
	public static final String INNER_DELIM = ":";

	public Message(String key, byte[] value)
	{
		this(key, new String(value));
	}
	
	public Message(String key, String value)
	{
		this.key = key.trim();
		this.value = value.trim();
	}
	
	public final String key, value;
	
	@Override
	public String toString()
	{
		return "Message[key(" + key + ") value(" + value + ")]";
	}
	
	/**
	 * Returns the bytes
	 * @return
	 * @throws IOException
	 */
	public byte[] getBytes()
	{
		return (key + INNER_DELIM + value + OUTER_DELIM).getBytes();
	}
}
