package li.rudin.arduino.api.ethernet;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.enterprise.util.Nonbinding;
import javax.inject.Qualifier;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
@Qualifier
public @interface Connection
{
	/**
	 * The host to connect to
	 * @return
	 */
	@Nonbinding
	String host();
	
	/**
	 * The port to connect to
	 * @return
	 */
	@Nonbinding
	int port() default 2000;
}
