package li.rudin.arduino.managed.cdi;

import java.util.Set;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

import li.rudin.arduino.api.ethernet.Connection;
import li.rudin.arduino.core.ethernet.ArduinoEthernetImpl;

import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;
import org.scannotation.WarUrlFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ManagedExtension implements Extension, ServletContextListener
{
	private final AnnotationDB db = new AnnotationDB();

	/**
	 * logger
	 */
	private static final Logger logger = LoggerFactory.getLogger(ManagedExtension.class);
	
	void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm)
	{
		try
		{
			logger.debug("Searching for managable devices");
			
			db.scanArchives( ClasspathUrlFinder.findClassPaths() );
			
			if (sce != null)
				db.scanArchives( WarUrlFinder.findWebInfLibClasspaths(sce) );
			else
				logger.debug("No ServletContextEvent found");

			
			Set<String> index = db.getAnnotationIndex().get(Connection.class.getName());
			
			if (index == null)
				//No annotations found
				return;
			
			for (String s: index)
			{
				Class<?> type = Class.forName(s);
				Connection connection = type.getAnnotation(Connection.class);
				
				if (connection != null)
				{
					logger.info("Creating device instance for type '{}', host: '{}' and port: '{}'", s, connection.host(), connection.port());
					
					abd.addBean(new ManagedDeviceBean(type, new ArduinoEthernetImpl(connection.host(), connection.port())));
				}
			}
			
		}
		catch (Exception e)
		{
			abd.addDefinitionError(e);
		}

	}
	
	private static ServletContextEvent sce;

	@Override
	public void contextInitialized(ServletContextEvent sce)
	{
		ManagedExtension.sce = sce;
	}

	@Override
	public void contextDestroyed(ServletContextEvent sce)
	{
	}
}
