/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.managed.cdi;

import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.ethernet.Connection;
import li.rudin.arduino.core.ethernet.ArduinoEthernetImpl;
import li.rudin.arduino.managed.cdi.ManagedDeviceBean;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;
import org.scannotation.WarUrlFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ManagedExtension
implements Extension,
ServletContextListener {
    private final AnnotationDB db = new AnnotationDB();
    private static final Logger logger = LoggerFactory.getLogger(ManagedExtension.class);
    private static ServletContextEvent sce;

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        try {
            logger.debug("Searching for managable devices");
            this.db.scanArchives(ClasspathUrlFinder.findClassPaths());
            if (sce != null) {
                this.db.scanArchives(WarUrlFinder.findWebInfLibClasspaths((ServletContextEvent)sce));
            } else {
                logger.debug("No ServletContextEvent found");
            }
            Set index = (Set)this.db.getAnnotationIndex().get(Connection.class.getName());
            if (index == null) {
                return;
            }
            for (String s : index) {
                Class<?> type = Class.forName(s);
                Connection connection = type.getAnnotation(Connection.class);
                if (connection == null) continue;
                logger.info("Creating device instance for type '{}', host: '{}' and port: '{}'", new Object[]{s, connection.host(), connection.port()});
                abd.addBean((Bean)new ManagedDeviceBean(type, (Arduino)new ArduinoEthernetImpl(connection.host(), connection.port())));
            }
        }
        catch (Exception e) {
            abd.addDefinitionError((Throwable)e);
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        ManagedExtension.sce = sce;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

