package li.rudin.arduino.managed.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;

import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.state.ConnectionState;
import li.rudin.arduino.managed.Managed;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedDeviceBean implements Bean<Object>, PassivationCapable
{
	
	/**
	 * Local logger
	 */
	private static final Logger logger = LoggerFactory.getLogger(ManagedDeviceBean.class);

	public ManagedDeviceBean(Class<?> type, Arduino arduino, BeanManager bm)
	{
		this.type = type;
		this.arduino = arduino;
		this.bm = bm;
	}
	
	private final BeanManager bm;
	
	private final Class<?> type;
	
	private final Arduino arduino;
	
	private Object instance;
	
	
	@Override
	public Object create(CreationalContext<Object> creationalContext)
	{
		if (instance == null)
		{
			logger.debug("Creating instance for type: {}", type);
			
			//Create enhanced instance
			instance = Managed.create(type, arduino);
			
			//Create event distributor
			EventDistributor distributor = new EventDistributor(bm, type);
			arduino.addListener(distributor);
			
			//Set arduino online
			arduino.setTargetState(ConnectionState.CONNECTED);
		}
		
		return instance;
	}

	@Override
	public void destroy(Object instance, CreationalContext<Object> creationalContext)
	{
		logger.debug("Destroying instance for type: {}", type);
		arduino.setTargetState(ConnectionState.DISCONNECTED);
		instance = null;
		
		creationalContext.release();
	}

	@Override
	public Set<Type> getTypes()
	{
		Set<Type> set = new HashSet<>();
		set.add(Object.class);
		set.add(type);
		set.add(Arduino.class);
		
		return set;
	}

	@SuppressWarnings("serial")
	@Override
	public Set<Annotation> getQualifiers()
	{
		Set<Annotation> set = new HashSet<>();
		set.add(new AnnotationLiteral<Default>() {});
		set.add(new AnnotationLiteral<Any>() {});
		
		return set;
	}

	@Override
	public Class<? extends Annotation> getScope()
	{
		return ApplicationScoped.class;
	}

	@Override
	public String getName()
	{
		return null;
	}

	@Override
	public Set<Class<? extends Annotation>> getStereotypes()
	{
		return Collections.emptySet();
	}

	@Override
	public boolean isAlternative()
	{
		return false;
	}

	@Override
	public Class<?> getBeanClass()
	{
		return type;
	}

	@Override
	public Set<InjectionPoint> getInjectionPoints()
	{
		return Collections.emptySet();
	}

	@Override
	public boolean isNullable()
	{
		return false;
	}

	@Override
	public String getId()
	{
		return "" + this.hashCode();
	}

}
