package li.rudin.arduino.managed.converter;

import java.lang.reflect.Method;

public class TypeConverter
{
	
	
	/**
	 * Converts an outgoing object to a readable String, if possible
	 * @param obj
	 * @return
	 */
	public static String convertOutgoing(Object obj)
	{
		Class<?> type = obj.getClass();
		
		if (type == String.class)
			return (String)obj;
		else if (type == Boolean.class || type == boolean.class)
			//convert boolean to 1 or 0
			return (boolean)obj ? "1" : "0";
		
		return obj.toString();
	}
	
	/**
	 * Converts an incoming string to the given type, if possible
	 * @param value
	 * @param type
	 * @return
	 */
	public static Object convertIncoming(String value, Class<?> type)
	{
		if (type == String.class)
			return value;
		else if (type == int.class || type == Integer.class)
			return Integer.parseInt(value);
		else if (type == boolean.class || type == Boolean.class)
			//1 = true, else false
			return value.equals("1");
		else if (type == double.class || type == Double.class)
			return Double.parseDouble(value);
		else if (type == float.class || type == Float.class)
			return Float.parseFloat(value);
		else if (type == long.class || type == Long.class)
			return Long.parseLong(value);
		else if (type == byte.class || type == Byte.class)
			return Byte.parseByte(value);
		else if (type.isEnum())
		{
			try
			{
				Method method = type.getMethod("valueOf", String.class);
				return method.invoke(null, value);
			}
			catch (Exception e)
			{
				return null;
			}
		}
			//Not mapped by conversion
			return null;
	}
	
}
