/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.managed.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import li.rudin.arduino.api.cdi.DeviceEvent;
import li.rudin.arduino.api.cdi.Direction;
import li.rudin.arduino.api.cdi.StateChangeEvent;
import li.rudin.arduino.api.listener.ArduinoListener;
import li.rudin.arduino.api.state.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDistributor
implements ArduinoListener {
    private static final Logger logger = LoggerFactory.getLogger(EventDistributor.class);
    private final BeanManager bm;
    private final Class<?> device;
    private ConnectionState previousState = ConnectionState.DISCONNECTED;

    public EventDistributor(BeanManager bm, Class<?> device) {
        this.bm = bm;
        this.device = device;
    }

    public void onMessageReceived(String key, String value) {
        logger.debug("Incoming event: device({}) key({}) value({})", new Object[]{this.device.getName(), key, value});
        this.fireDynamic(key, value, Direction.INCOMING);
    }

    public void onMessageTransmitted(String key, String value) {
        logger.debug("Outgoing event: device({}) key({}) value({})", new Object[]{this.device.getName(), key, value});
        this.fireDynamic(key, value, Direction.OUTGOING);
    }

    private void fireDynamic(String key, String value, Direction direction) {
        DeviceEventType annotationType = new DeviceEventType(this.device, key, direction);
        this.bm.fireEvent((Object)value, new Annotation[]{annotationType});
        if (value.length() == 0) {
            return;
        }
        try {
            Integer i = Integer.parseInt(value);
            this.bm.fireEvent((Object)i, new Annotation[]{annotationType});
            if (i.equals(1)) {
                this.bm.fireEvent((Object)true, new Annotation[]{annotationType});
            } else if (i.equals(0)) {
                this.bm.fireEvent((Object)false, new Annotation[]{annotationType});
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            Double d = Double.parseDouble(value);
            this.bm.fireEvent((Object)d, new Annotation[]{annotationType});
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            Long l = Long.parseLong(value);
            this.bm.fireEvent((Object)l, new Annotation[]{annotationType});
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public void onStateChange(ConnectionState currentState, ConnectionState targetState) {
        if (this.previousState != currentState) {
            logger.debug("Distributing state change: current({}) previous({})", (Object)currentState, (Object)this.previousState);
            DeviceEventType annotationType = new DeviceEventType(this.device, "", Direction.INCOMING);
            this.bm.fireEvent((Object)new StateChangeEvent(this.previousState, currentState), new Annotation[]{annotationType});
            this.previousState = currentState;
        }
    }

    public static class DeviceEventType
    implements DeviceEvent {
        private final Class<?> device;
        private final String key;
        private final Direction direction;

        public DeviceEventType(Class<?> device, String key, Direction direction) {
            this.device = device;
            this.direction = direction;
            this.key = key;
        }

        public Class<? extends Annotation> annotationType() {
            return DeviceEvent.class;
        }

        public Class<?> device() {
            return this.device;
        }

        public String key() {
            return this.key;
        }

        public Direction direction() {
            return this.direction;
        }
    }
}

