/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.managed.cdi;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.cache.KeyValueCache;
import li.rudin.arduino.api.cdi.Connection;
import li.rudin.arduino.core.cache.TimedKeyValueCache;
import li.rudin.arduino.core.ethernet.ArduinoEthernetImpl;
import li.rudin.arduino.core.serial.ArduinoSerialImpl;
import li.rudin.arduino.managed.cdi.ManagedDeviceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(ManagedExtension.class);
    private final List<Class<?>> deviceList = new ArrayList();

    <X> void processAnnotatedType(@Observes @WithAnnotations(value={Connection.class}) ProcessAnnotatedType<X> pat) {
        AnnotatedType type = pat.getAnnotatedType();
        if (type.getAnnotation(Connection.class) != null) {
            logger.info("Found managed device class: '{}'", (Object)type.getJavaClass().getName());
            this.deviceList.add(type.getJavaClass());
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        try {
            for (Class<?> type : this.deviceList) {
                ArduinoEthernetImpl arduino;
                Connection connection = type.getAnnotation(Connection.class);
                if (connection == null) continue;
                if (connection.host().length() > 0) {
                    logger.info("Creating ethernet device instance for type '{}', host: '{}' and port: '{}'", new Object[]{type.getName(), connection.host(), connection.port()});
                    arduino = new ArduinoEthernetImpl(connection.host(), connection.port());
                    arduino.setCache((KeyValueCache)new TimedKeyValueCache());
                    abd.addBean((Bean)new ManagedDeviceBean(type, (Arduino)arduino, bm));
                    continue;
                }
                if (connection.serialPort().length() <= 0) continue;
                logger.info("Creating serial device instance for type: '{}' speed: '{}' and port: '{}'", new Object[]{type.getName(), connection.serialSpeed(), connection.serialPort()});
                arduino = new ArduinoSerialImpl(connection.serialPort(), connection.serialSpeed());
                arduino.setCache((KeyValueCache)new TimedKeyValueCache());
                abd.addBean((Bean)new ManagedDeviceBean(type, (Arduino)arduino, bm));
            }
        }
        catch (Exception e) {
            abd.addDefinitionError((Throwable)e);
        }
    }
}

