/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.managed.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.state.ConnectionState;
import li.rudin.arduino.managed.Managed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedDeviceBean
implements Bean<Object>,
PassivationCapable {
    private static final Logger logger = LoggerFactory.getLogger(ManagedDeviceBean.class);
    private final Class<?> type;
    private final Arduino arduino;
    private Object instance;

    public ManagedDeviceBean(Class<?> type, Arduino arduino) {
        this.type = type;
        this.arduino = arduino;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        if (this.instance == null) {
            logger.debug("Creating instance for type: {}", this.type);
            this.arduino.setTargetState(ConnectionState.CONNECTED);
            this.instance = Managed.create(this.type, this.arduino);
        }
        return this.instance;
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
        logger.debug("Destroying instance for type: {}", this.type);
        this.arduino.setTargetState(ConnectionState.DISCONNECTED);
        instance = null;
    }

    public Set<Type> getTypes() {
        HashSet<Type> set = new HashSet<Type>();
        set.add((Type)((Object)Object.class));
        set.add(this.type);
        set.add((Type)((Object)Arduino.class));
        return set;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> set = new HashSet<Annotation>();
        set.add((Annotation)new AnnotationLiteral<Default>(){});
        set.add((Annotation)new AnnotationLiteral<Any>(){});
        return set;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public String getId() {
        return "" + this.hashCode();
    }
}

