/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.managed;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.converter.TypeConverter;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ManagedInterceptor.class);
    public final Arduino arduino;
    public final Class<?> type;

    public ManagedInterceptor(Class<?> type, Arduino arduino) {
        this.arduino = arduino;
        this.type = type;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String methodName = method.getName();
        Class<?> methodOwner = method.getDeclaringClass();
        logger.debug("Intercepted method {}.{}", (Object)methodOwner.getSimpleName(), (Object)methodName);
        if (!Modifier.isAbstract(method.getModifiers())) {
            return proxy.invokeSuper(obj, args);
        }
        if (methodOwner == Arduino.class) {
            return proxy.invoke((Object)this.arduino, args);
        }
        if (methodName.startsWith("get")) {
            String key = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            String str = this.arduino.get(key);
            if (str == null) {
                throw new IllegalArgumentException("null-result from query: " + key);
            }
            str = str.trim();
            Class<?> type = method.getReturnType();
            return TypeConverter.convertIncoming((String)str, type);
        }
        if (methodName.startsWith("set")) {
            String key = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            if (args.length == 1) {
                this.arduino.send(key, TypeConverter.convertOutgoing((Object)args[0]));
            } else if (args.length == 0) {
                this.arduino.send(key, "");
            }
            return null;
        }
        if (methodName.startsWith("do")) {
            String key = methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
            if (args.length == 1) {
                this.arduino.send(key, TypeConverter.convertOutgoing((Object)args[0]));
            } else if (args.length == 0) {
                this.arduino.send(key, "");
            }
        }
        return null;
    }
}

