/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.managed.cdi;

import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.servlet.annotation.WebListener;
import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.cache.KeyValueCache;
import li.rudin.arduino.api.ethernet.Connection;
import li.rudin.arduino.core.cache.TimedKeyValueCache;
import li.rudin.arduino.core.ethernet.ArduinoEthernetImpl;
import li.rudin.arduino.managed.cdi.ManagedDeviceBean;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ManagedExtension
implements Extension {
    private static final Reflections reflections;
    private static final Logger logger;

    public static Set<URL> effectiveClassPathUrls(ClassLoader ... classLoaders) {
        return ClasspathHelper.forManifest((Iterable)ClasspathHelper.forClassLoader((ClassLoader[])classLoaders));
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        try {
            logger.info("Searching for managable devices");
            Set types = reflections.getTypesAnnotatedWith(Connection.class);
            for (Class type : types) {
                Connection connection = type.getAnnotation(Connection.class);
                if (connection == null) continue;
                logger.info("Creating device instance for type '{}', host: '{}' and port: '{}'", new Object[]{type.getName(), connection.host(), connection.port()});
                ArduinoEthernetImpl arduino = new ArduinoEthernetImpl(connection.host(), connection.port());
                arduino.setCache((KeyValueCache)new TimedKeyValueCache());
                abd.addBean((Bean)new ManagedDeviceBean(type, (Arduino)arduino));
            }
        }
        catch (Exception e) {
            abd.addDefinitionError((Throwable)e);
        }
    }

    static {
        ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ConfigurationBuilder config = ConfigurationBuilder.build((Object[])new Object[0]).setExecutorService(pool).addUrls(ManagedExtension.effectiveClassPathUrls(ManagedExtension.class.getClassLoader()));
        Iterator it = config.getUrls().iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            if (!url.getFile().contains(".so.")) continue;
            it.remove();
        }
        reflections = new Reflections((Configuration)config);
        pool.shutdown();
        logger = LoggerFactory.getLogger(ManagedExtension.class);
    }
}

