/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.managed.cdi;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.servlet.annotation.WebListener;
import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.cache.KeyValueCache;
import li.rudin.arduino.api.ethernet.Connection;
import li.rudin.arduino.core.cache.TimedKeyValueCache;
import li.rudin.arduino.core.ethernet.ArduinoEthernetImpl;
import li.rudin.arduino.managed.cdi.ManagedDeviceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ManagedExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(ManagedExtension.class);
    private final List<Class<?>> deviceList = new ArrayList();

    <X> void processAnnotatedTyp(@Observes ProcessAnnotatedType<X> pat) {
        AnnotatedType type = pat.getAnnotatedType();
        if (type.getAnnotation(Connection.class) != null) {
            logger.info("Found managed device class: '{}'", (Object)type.getJavaClass().getName());
            this.deviceList.add(type.getJavaClass());
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        try {
            logger.info("Searching for managable devices");
            for (Class<?> type : this.deviceList) {
                Connection connection = type.getAnnotation(Connection.class);
                if (connection == null) continue;
                logger.info("Creating device instance for type '{}', host: '{}' and port: '{}'", new Object[]{type.getName(), connection.host(), connection.port()});
                ArduinoEthernetImpl arduino = new ArduinoEthernetImpl(connection.host(), connection.port());
                arduino.setCache((KeyValueCache)new TimedKeyValueCache());
                abd.addBean((Bean)new ManagedDeviceBean(type, (Arduino)arduino));
            }
        }
        catch (Exception e) {
            abd.addDefinitionError((Throwable)e);
        }
    }
}

