package li.rudin.arduino.testsuite;

import java.util.Random;

import org.junit.After;
import org.junit.Before;

public abstract class AbstractArduinoTest
{
	private static final Random RNG = new Random();
	
	private int PORT = RNG.nextInt(10000) + 10000;
	public static final String HOST = "127.0.0.1";
	
	public int getPort()
	{
		return PORT;
	}
	
	@Before
	public void before() throws Exception
	{
		server = new ArduinoEthernetDeviceServer(getPort());
		server.start();
	}
	
	protected ArduinoEthernetDeviceServer server;
	
	@After
	public void after() throws Exception
	{
		server.stop();
	}

}
