package li.rudin.arduino.testsuite;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;

import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.cache.KeyValueCache;
import li.rudin.arduino.api.enums.Attribute;
import li.rudin.arduino.api.listener.ArduinoListener;
import li.rudin.arduino.api.message.Message;
import li.rudin.arduino.api.state.ConnectionState;

public class MockedArduinoDevice implements Arduino
{
	
	public MockedArduinoDevice()
	{
		keyValueMap.put("commversion", "1.0");
	}
	
	public final Stack<Message> sentMessages = new Stack<>();

	@Override
	public void send(String key, String value)
	{
		sentMessages.add(new Message(key, value));
		
		if (value.length() == 0)
		{
			//Getter
		}
		else
		{
			//Setter
			keyValueMap.put(key, value);
		}
		
		fireTransmitted(key, value);
	}
	
	/**
	 * Test method to simulate received events from the arduino
	 * @param key
	 * @param value
	 */
	public void receive(String key, String value)
	{
		keyValueMap.put(key, value.trim());
		fireReceived(key, value.trim());
	}

	public final Map<String, String> keyValueMap = new HashMap<>();
	
	@Override
	public String get(String key, Attribute...attributes)
	{
		return keyValueMap.get(key);
	}

	private ConnectionState state;
	
	@Override
	public ConnectionState getCurrentState()
	{
		return state;
	}

	@Override
	public ConnectionState getTargetState()
	{
		return state;
	}

	@Override
	public void setTargetState(ConnectionState state)
	{
		this.state = state;
	}

	@Override
	public void setCache(KeyValueCache cache)
	{
		// TODO Auto-generated method stub
		
	}

	@Override
	public KeyValueCache getCache()
	{
		// TODO Auto-generated method stub
		return null;
	}
	
	private final List<ArduinoListener> listeners = new CopyOnWriteArrayList<>();

	@Override
	public void addListener(ArduinoListener listener)
	{
		listeners.add(listener);
	}

	@Override
	public void removeListener(ArduinoListener listener)
	{
		listeners.remove(listener);
	}
	
	/**
	 * Fires the rx event
	 * @param key
	 * @param value
	 */
	public void fireReceived(String key, String value)
	{
		for (ArduinoListener l: listeners)
			l.onMessageReceived(key, value);
	}

	/**
	 * Fires the tx event
	 * @param key
	 * @param value
	 */
	public void fireTransmitted(String key, String value)
	{
		for (ArduinoListener l: listeners)
			l.onMessageTransmitted(key, value);
	}


}
