/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.testsuite;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import li.rudin.arduino.api.message.Message;
import li.rudin.arduino.core.message.MessageTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArduinoEthernetDeviceServer
implements Runnable,
Consumer<Message> {
    private static final Logger logger = LoggerFactory.getLogger(ArduinoEthernetDeviceServer.class);
    private final Map<String, String> valueMap = new HashMap<String, String>();
    private final int port;
    private boolean run = false;
    private ServerSocket serversocket;
    private final MessageTranslator translator = new MessageTranslator((Consumer)this, false);
    private List<Client> clients = new CopyOnWriteArrayList<Client>();
    private final Stack<Message> rxMessages = new Stack();

    public ArduinoEthernetDeviceServer(int port) {
        this.port = port;
    }

    public void start() throws IOException {
        this.run = true;
        this.serversocket = new ServerSocket(this.port);
        new Thread(this).start();
    }

    public void stop() throws IOException {
        logger.debug("Stopping server @ port {}", (Object)this.port);
        this.run = false;
        this.serversocket.close();
        for (Client c : this.clients) {
            c.stop();
        }
        logger.debug("Stopped server @ port {}", (Object)this.port);
    }

    public void send(String key, String value) throws IOException {
        for (Client c : this.clients) {
            try {
                c.send(key, value);
            }
            catch (Exception e) {
                logger.error("send to client", (Throwable)e);
            }
        }
    }

    public void send(String raw) throws IOException {
        for (Client c : this.clients) {
            c.send(raw);
        }
    }

    @Override
    public void run() {
        while (this.run) {
            try {
                Socket socket = this.serversocket.accept();
                new Client(socket);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public Stack<Message> getRxMessages() {
        return this.rxMessages;
    }

    public Map<String, String> getValueMap() {
        return this.valueMap;
    }

    @Override
    public void accept(Message msg) {
        logger.debug("Got {}", (Object)msg);
        if (msg.value.length() == 0 && this.valueMap.containsKey(msg.key)) {
            try {
                String value = this.valueMap.get(msg.key);
                logger.debug("Sending key: {}, value: '{}'", (Object)msg.key, (Object)value);
                this.send(msg.key, value);
            }
            catch (Exception e) {
                logger.error("send()", (Throwable)e);
            }
        } else {
            this.rxMessages.push(msg);
        }
    }

    class Client
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(Client.class);
        private final InputStream input;
        private final OutputStream output;
        private final Socket socket;

        public Client(Socket socket) throws IOException {
            this.input = socket.getInputStream();
            this.output = socket.getOutputStream();
            this.socket = socket;
            ArduinoEthernetDeviceServer.this.clients.add(this);
            new Thread(this).start();
        }

        public void send(String key, String value) throws IOException {
            this.output.write(new Message(key, value).getBytes());
            this.output.flush();
        }

        public void send(String raw) throws IOException {
            this.output.write(raw.getBytes());
            this.output.flush();
        }

        public void stop() throws IOException {
            this.socket.close();
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            while (ArduinoEthernetDeviceServer.this.run) {
                try {
                    int count = this.input.read(buffer);
                    this.logger.debug("Read {} bytes", (Object)count);
                    if (count < 0) {
                        return;
                    }
                    String str = new String(buffer, 0, count);
                    ArduinoEthernetDeviceServer.this.translator.accept(str);
                    try {
                        ArduinoEthernetDeviceServer.this.translator.run();
                    }
                    catch (Exception e) {
                        this.logger.error("Error in listener", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }
}

