/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.arduino.testsuite;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import li.rudin.arduino.api.Arduino;
import li.rudin.arduino.api.cache.KeyValueCache;
import li.rudin.arduino.api.listener.ArduinoListener;
import li.rudin.arduino.api.message.Message;
import li.rudin.arduino.api.state.ConnectionState;

public class MockedArduinoDevice
implements Arduino {
    public final Stack<Message> sentMessages = new Stack();
    public final Map<String, String> keyValueMap = new HashMap<String, String>();
    private ConnectionState state;
    private final List<ArduinoListener> listeners = new CopyOnWriteArrayList<ArduinoListener>();

    public MockedArduinoDevice() {
        this.keyValueMap.put("commversion", "1.0");
    }

    public void send(String key, String value) {
        this.sentMessages.add(new Message(key, value));
        if (value.length() != 0) {
            this.keyValueMap.put(key, value);
        }
        this.fireTransmitted(key, value);
    }

    public void receive(String key, String value) {
        this.keyValueMap.put(key, value);
        this.fireReceived(key, value);
    }

    public String get(String key) {
        return this.keyValueMap.get(key);
    }

    public ConnectionState getCurrentState() {
        return this.state;
    }

    public ConnectionState getTargetState() {
        return this.state;
    }

    public void setTargetState(ConnectionState state) {
        this.state = state;
    }

    public void setCache(KeyValueCache cache) {
    }

    public KeyValueCache getCache() {
        return null;
    }

    public void addListener(ArduinoListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ArduinoListener listener) {
        this.listeners.remove(listener);
    }

    public void fireReceived(String key, String value) {
        for (ArduinoListener l : this.listeners) {
            l.onMessageReceived(key, value);
        }
    }

    public void fireTransmitted(String key, String value) {
        for (ArduinoListener l : this.listeners) {
            l.onMessageTransmitted(key, value);
        }
    }
}

