package li.rudin.cdi.async;

import java.lang.reflect.Method;
import java.util.concurrent.Future;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

import net.sf.cglib.proxy.Enhancer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@Async
@Priority(100)
public class AsyncInterceptor
{
	
	/**
	 * Local logger
	 */
	private static final Logger logger = LoggerFactory.getLogger(AsyncInterceptor.class);
	
	@Inject ThreadPool pool;
	
	
	@AroundInvoke
	public Object intercept(InvocationContext ctx) throws Exception
	{
		Class<?> type = ctx.getMethod().getDeclaringClass();
		Method method = ctx.getMethod();
		
		logger.debug("Intercepting: {}.{}", type.getName(), method.getName());

		if (pool.isAsync())
		{
			logger.debug("Thread already marked as async/active");
			Object result = ctx.proceed();
			logger.debug("Got result: {}", result);
			return result;
		}
		
		Future<Object> future = pool.submit(ctx);
		
		Class<?> returnType = method.getReturnType();
		
		if (returnType == void.class || returnType == Void.class)
			//No result value
			return null;
		
		//Result value, proxy it
		return Enhancer.create(returnType, new ResultInterceptor<>(future));
	}

}
