package li.rudin.cdi.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.interceptor.InvocationContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ThreadPool
{

	/**
	 * Cached thread pool
	 */
	private ExecutorService pool = Executors.newCachedThreadPool();


	@PreDestroy
	void shutdown()
	{
		pool.shutdown();
	}


	private static final ThreadLocal<Boolean> asyncMarker = new ThreadLocal<Boolean>(){
		@Override
		protected Boolean initialValue()
		{
			return false;
		}
	};

	/**
	 * Submits an invocation context call
	 * @param ctx
	 * @return
	 * @throws Exception
	 */
	public Future<Object> submit(InvocationContext ctx) throws Exception
	{
		return pool.submit(new AsyncCallable(ctx));
	}

	/**
	 * Returns true if already async
	 * @return
	 */
	public boolean isAsync()
	{
		return asyncMarker.get();
	}

	/**
	 * Async Callable
	 * @author user
	 *
	 */
	private static class AsyncCallable implements Callable<Object>
	{

		/**
		 * Local logger
		 */
		private static final Logger logger = LoggerFactory.getLogger(AsyncCallable.class);

		public AsyncCallable(InvocationContext ctx)
		{
			this.ctx = ctx;
		}

		private final InvocationContext ctx;

		@Override
		public Object call() throws Exception
		{
			asyncMarker.set(true);
			try
			{
				Object result = ctx.proceed();
				logger.debug("Got result: {}", result);
				return result;
			}
			finally
			{
				asyncMarker.set(false);
			}
		}

	}
}
