/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.cdi.async;

import java.lang.reflect.Method;
import java.util.concurrent.Future;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import li.rudin.cdi.async.Async;
import li.rudin.cdi.async.ResultInterceptor;
import li.rudin.cdi.async.ThreadPool;
import net.sf.cglib.proxy.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@Async
@Priority(value=100)
public class AsyncInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AsyncInterceptor.class);
    @Inject
    ThreadPool pool;

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        Class<?> type = ctx.getMethod().getDeclaringClass();
        Method method = ctx.getMethod();
        logger.debug("Intercepting: {}.{}", (Object)type.getName(), (Object)method.getName());
        if (this.pool.isAsync()) {
            logger.debug("Thread already marked as async/active");
            Object result = ctx.proceed();
            logger.debug("Got result: {}", result);
            return result;
        }
        Future<Object> future = this.pool.submit(ctx);
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return null;
        }
        return Enhancer.create(returnType, new ResultInterceptor<Object>(future));
    }
}

