/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.cdi.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ThreadPool {
    private ExecutorService pool = Executors.newCachedThreadPool();
    private static final ThreadLocal<Boolean> asyncMarker = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    @PreDestroy
    void shutdown() {
        this.pool.shutdown();
    }

    public Future<Object> submit(InvocationContext ctx) throws Exception {
        return this.pool.submit(new AsyncCallable(ctx));
    }

    public boolean isAsync() {
        return asyncMarker.get();
    }

    private static class AsyncCallable
    implements Callable<Object> {
        private static final Logger logger = LoggerFactory.getLogger(AsyncCallable.class);
        private final InvocationContext ctx;

        public AsyncCallable(InvocationContext ctx) {
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            asyncMarker.set(true);
            try {
                Object result = this.ctx.proceed();
                logger.debug("Got result: {}", result);
                Object object = result;
                return object;
            }
            finally {
                asyncMarker.set(false);
            }
        }
    }
}

