package li.rudin.cdi.async.impl.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

import li.rudin.cdi.async.AsyncEvent;

/**
 * https://weblogs.java.net/blog/jjviana/archive/2010/04/14/decoupling-event-producers-and-event-consumers-java-ee-6-using-cdi-a
 * @author user
 *
 */
public class AsyncEventExtension implements Extension
{
	/**
	 * Cached thread pool
	 */
	private ExecutorService pool = Executors.newCachedThreadPool();

	private List<ObserverMethod<?>> asyncObservers = new ArrayList<ObserverMethod<?>>();
	
	public <X> void onProcessAnnotatedType(@Observes ProcessAnnotatedType<X> event, final BeanManager beanManager) {
        final AnnotatedType<X> type = event.getAnnotatedType();
        for (AnnotatedMethod<?> method : type.getMethods()) {
            for (final AnnotatedParameter<?> param : method.getParameters()) {
                if (param.isAnnotationPresent(Observes.class) && param.isAnnotationPresent(AsyncEvent.class)) {
                    asyncObservers.add(SimpleObserverMethod.create(this.pool, beanManager, type, method, param));
                }
            }
        }
    }

    public void onAfterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        for (ObserverMethod<?> om : this.asyncObservers) {
            event.addObserverMethod(om);
        }
    }

    public void onBeforeShutdown(@Observes BeforeShutdown event) {
        this.pool.shutdown();
    }
}
