package li.rudin.cdi.async.impl.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ObserverMethod;

import li.rudin.cdi.async.AsyncEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleObserverMethod<T> implements ObserverMethod<T>
{
	private static final Logger logger = LoggerFactory.getLogger(SimpleObserverMethod.class);

	private ExecutorService       pool;
	private BeanManager           bm;
	private AnnotatedType<?>      type;
	private AnnotatedMethod<?>    method;
	private AnnotatedParameter<?> param;
	private Set<Annotation>       qualifiers;
	private Reception             reception;
	private TransactionPhase      txnPhase;

	private SimpleObserverMethod() {
	}

	public static <T> ObserverMethod<T> create(ExecutorService pool, BeanManager bm, AnnotatedType<?> type, AnnotatedMethod<?> method, AnnotatedParameter<?> param) {
		SimpleObserverMethod<T> som = new SimpleObserverMethod<T>();
		som.pool = pool;
		som.bm = bm;
		som.type = type;
		som.method = method;
		som.param = param;
		som.qualifiers = new HashSet<Annotation>();
		for (Annotation annotation : param.getAnnotations()) {
			if (bm.isQualifier(annotation.getClass()) && !annotation.annotationType().equals(AsyncEvent.class)) {
				som.qualifiers.add(annotation);
				if (annotation.annotationType().equals(Observes.class)) {
					Observes observes = (Observes) annotation;
					som.reception = observes.notifyObserver();
					som.txnPhase = observes.during();
				}
			}
		}
		return som;
	}

	public Class<?> getBeanClass() {
		return this.type.getJavaClass();
	}

	public Type getObservedType() {
		return this.param.getBaseType();
	}

	public Set<Annotation> getObservedQualifiers() {
		return this.qualifiers;
	}

	public Reception getReception() {
		return this.reception;
	}

	public TransactionPhase getTransactionPhase() {
		return this.txnPhase;
	}

	public void notify(T event) {
		if (this.method.isStatic()) {
			this.notify(null, method.getJavaMember(), event);
		} else {
			for (Bean<?> bean : this.bm.getBeans(this.type.getBaseType())) {
				CreationalContext<?> ctx = this.bm.createCreationalContext(bean);
				Object target = this.bm.getReference(bean, this.type.getBaseType(), ctx);
				this.notify(target, method.getJavaMember(), event);
			}
		}
	}

	private void notify(final Object target, final Method method, final T event) {
		this.pool.execute(new Runnable() {
			public void run() {
				try
				{
					if (!method.isAccessible())
						method.setAccessible(true);
					
					method.invoke(target, event);
				} catch (Exception e) {
					logger.error("Exception while dispatching event:", e);
				}
			}
		});
	}
}
