package li.rudin.cdi.async.impl.method;

import java.lang.reflect.Method;
import java.util.concurrent.Future;

import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class ResultInterceptor<T> implements MethodInterceptor
{
	public ResultInterceptor(Future<T> future)
	{
		this.future = future;
	}
	
	private final Future<T> future;

	private T result;

	@Override
	public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable
	{
		if (result == null)
			result = future.get();
		
		return proxy.invoke(result, args);
	}

}
